<?php

namespace Config;

use CodeIgniter\Shield\Config\AuthGroups as ShieldAuthGroups;

class AuthGroups extends ShieldAuthGroups
{
    public string $defaultGroup = 'staff';

    public array $groups = [
        'admin' => [
            'title'       => 'Admin',
            'description' => 'Full access to administrative modules.',
        ],
        'staff' => [
            'title'       => 'Staff',
            'description' => 'Operational staff with standard access.',
        ],
        'teacher' => [
            'title'       => 'Teacher',
            'description' => 'Teachers with classroom-related access.',
        ],
        'student' => [
            'title'       => 'Student',
            'description' => 'Students with limited access.',
        ],
    ];

    /**
     * Application permissions catalog (key => human-friendly description).
     * Keys are namespaced to enable wildcard matching in the matrix.
     */
    public array $permissions = [
        // Dashboard
        'dashboard.access'                => 'Access Dashboard',

        // Setup / Maintenance
        'setup.school_year'               => 'School Year Maintenance',
        'setup.stage'                     => 'Stage/Class Maintenance',
        'setup.section'                   => 'Section Maintenance',
        'setup.degree'                    => 'Degree Maintenance',
        'setup.nationality'               => 'Nationality Maintenance',
        'setup.religion'                  => 'Religion Maintenance',
        'setup.payment_type'              => 'Payment Type Maintenance',
        'setup.tuition_type'              => 'Tuition Type Maintenance',
        'setup.item'                      => 'Item Maintenance',

        // Core modules
        'students.manage'                 => 'Students Maintenance',
        'teachers.manage'                 => 'Teachers Maintenance',
        'enrollment.registration'         => 'Registration / Enrollment',
        'payments.manage_receipts'        => 'Cash Receipts / Payments',

        // Accounting
        'accounting.chart_of_accounts'    => 'Chart of Accounts',
        'accounting.journal_vouchers'     => 'Journal Vouchers',
        'accounting.bank_deposit'         => 'Bank Deposit',
        'accounting.ledger'               => 'Ledger',
        'accounting.vat_overview'         => 'VAT / Tax Overview',

        // HR
        'hr.employees'                    => 'Employees',
        'hr.attendance'                   => 'Attendance',
        'hr.leave'                        => 'Leave Management',
        'hr.contracts'                    => 'Contracts',

        // Payroll
        'payroll.runs'                    => 'Payroll Runs',
        'payroll.payslips'                => 'Payslips',
        'payroll.salary_grades'           => 'Salary Grades',
        'payroll.deductions'              => 'Deductions',
        'payroll.benefits'                => 'Benefits',

        // Reports
        'reports.cash_collection'         => 'Cash Collection Report',
        'reports.summary'                 => 'Summary Report',
        'reports.statement_of_account'    => 'Statement of Account',
        'reports.transportation_statement'=> 'Transportation Statement',
        'reports.paid_unpaid_dues'        => 'Paid and Unpaid Dues',
        'reports.history'                 => 'History Report',
        'reports.tuition_paid_balance'    => 'Tuition Paid Balance',

        // System / Security / Actions
        'security.restriction'            => 'Security Restriction',
        'system.backup'                   => 'Backup',
        'meta.save'                       => 'Save',
        'meta.modify'                     => 'Modify',
        'meta.delete'                     => 'Delete',
    ];

    /**
     * Map permissions to groups. Wildcards apply to namespaced keys.
     */
    public array $matrix = [
        'admin' => [
            'dashboard.*',
            'setup.*',
            'students.*',
            'teachers.*',
            'enrollment.*',
            'payments.*',
            'accounting.*',
            'hr.*',
            'payroll.*',
            'reports.*',
            'security.*',
            'system.*',
            'meta.*',
        ],
        'staff' => [
            'dashboard.access',
            'setup.payment_type',
            'setup.section',
            'students.manage',
            'teachers.manage',
            'enrollment.registration',
            // HR/Payroll not granted by default; assign per user as needed
            // Removed default Payments and Accounting broad access; grant per-user as needed
            'reports.cash_collection',
            'reports.summary',
            'reports.history',
        ],
        'teacher' => [
            'dashboard.access',
            'reports.statement_of_account',
        ],
        'student' => [
            // intentionally minimal
        ],
    ];
}

