<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

class BaseController extends Controller
{
    /**
     * @var \CodeIgniter\Session\Session
     */
    protected $session;

    /**
     * @return void
     */
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);

        // Preload any models, libraries, etc, here.

        // E.g.: $this->session = service('session');
        
        // Handle language switching globally
        $session = session();
        $locale = $request->getGet('lang');
        if ($locale && in_array($locale, ['en', 'ar'])) {
            $session->set('app_locale', $locale);
        }
        
        // Use configured default locale if none set in session
        $currentLocale = $session->get('app_locale') ?? config('App')->defaultLocale;
        
        // Set the locale for the language helper
        service('language')->setLocale($currentLocale);
    }
}
