<?php
namespace App\Controllers\Settings;

use App\Controllers\BaseController;

class SystemController extends BaseController
{
    public function language()
    {
        $currentLocale = session()->get('app_locale') ?? config('App')->defaultLocale;
        return view('settings/language', [
            'title' => lang('App.language_settings'),
            'currentLocale' => $currentLocale,
        ]);
    }

    public function saveLanguage()
    {
        $locale = $this->request->getPost('locale');
        if (! in_array($locale, ['en', 'ar'])) {
            return redirect()->back()->with('error', 'Invalid language selection.');
        }
        session()->set('app_locale', $locale);
        return redirect()->back()->with('success', 'Language updated.');
    }

    public function school()
    {
        // Placeholder: School Info settings page
        return view('settings/school', [
            'title' => lang('App.school_info'),
        ]);
    }

    public function general()
    {
        // Placeholder: General settings page
        return view('settings/general', [
            'title' => lang('App.general_settings'),
        ]);
    }
}
