<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateSchoolYears extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [ 'type' => 'INT', 'unsigned' => true, 'auto_increment' => true ],
            'sno' => [ 'type' => 'VARCHAR', 'constraint' => 20 ],
            'school_year' => [ 'type' => 'VARCHAR', 'constraint' => 20 ],
            'status' => [ 'type' => 'ENUM', 'constraint' => ['active','inactive'], 'default' => 'active' ],
            'created_at' => [ 'type' => 'DATETIME', 'null' => true ],
            'updated_at' => [ 'type' => 'DATETIME', 'null' => true ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('school_years');
    }

    public function down()
    {
        $this->forge->dropTable('school_years');
    }
}
