<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreatePaymentTypes extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [ 'type' => 'INT', 'unsigned' => true, 'auto_increment' => true ],
            'description_en' => [ 'type' => 'VARCHAR', 'constraint' => 150 ],
            'description_ar' => [ 'type' => 'VARCHAR', 'constraint' => 150 ],
            'amount' => [ 'type' => 'DECIMAL', 'constraint' => '10,2', 'default' => 0 ],
            'created_at' => [ 'type' => 'DATETIME', 'null' => true ],
            'updated_at' => [ 'type' => 'DATETIME', 'null' => true ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('payment_types');
    }

    public function down()
    {
        $this->forge->dropTable('payment_types');
    }
}
