<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateReligions extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [ 'type' => 'INT', 'unsigned' => true, 'auto_increment' => true ],
            'name_en' => [ 'type' => 'VARCHAR', 'constraint' => 100 ],
            'name_ar' => [ 'type' => 'VARCHAR', 'constraint' => 100, 'null' => true ],
            'created_at' => [ 'type' => 'DATETIME', 'null' => true ],
            'updated_at' => [ 'type' => 'DATETIME', 'null' => true ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('religions');
    }

    public function down()
    {
        $this->forge->dropTable('religions');
    }
}
