<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddPaymentMethodToReceipts extends Migration
{
    public function up()
    {
        $fields = [
            'payment_method' => [ 'type' => 'VARCHAR', 'constraint' => 20, 'default' => 'cash', 'null' => false ],
        ];
        $this->forge->addColumn('receipts', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('receipts', 'payment_method');
    }
}
