<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateChartOfAccounts extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'code' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
                'null' => false,
            ],
            'name_en' => [
                'type' => 'VARCHAR',
                'constraint' => 120,
                'null' => false,
            ],
            'name_ar' => [
                'type' => 'VARCHAR',
                'constraint' => 120,
                'null' => true,
            ],
            'type' => [
                'type' => 'VARCHAR',
                'constraint' => 20, // Asset, Liability, Equity, Revenue, Expense
                'null' => false,
            ],
            'parent_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],
            'level' => [
                'type' => 'TINYINT',
                'unsigned' => true,
                'default' => 1,
            ],
            'is_postable' => [
                'type' => 'TINYINT',
                'unsigned' => true,
                'default' => 1,
            ],
            'normal_balance' => [
                'type' => 'VARCHAR',
                'constraint' => 6, // Debit or Credit
                'null' => false,
            ],
            'is_active' => [
                'type' => 'TINYINT',
                'unsigned' => true,
                'default' => 1,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->addUniqueKey('code');
        $this->forge->addForeignKey('parent_id', 'chart_of_accounts', 'id', 'SET NULL', 'SET NULL');
        $this->forge->createTable('chart_of_accounts', true);
    }

    public function down()
    {
        $this->forge->dropTable('chart_of_accounts', true);
    }
}
