<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateBankDeposits extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'deposit_no' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => true,
            ],
            'date' => [
                'type' => 'DATE',
                'null' => false,
            ],
            'bank_account_code' => [
                'type' => 'VARCHAR',
                'constraint' => 25,
                'null' => false,
            ],
            'description' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'amount' => [
                'type' => 'DECIMAL',
                'constraint' => '12,2',
                'null' => false,
                'default' => '0.00',
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('bank_deposits', true);
    }

    public function down()
    {
        $this->forge->dropTable('bank_deposits', true);
    }
}
