<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateGeneralLedger extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [ 'type' => 'INT', 'unsigned' => true, 'auto_increment' => true ],
            'entry_date' => [ 'type' => 'DATE', 'null' => false ],
            'source_type' => [ 'type' => 'VARCHAR', 'constraint' => 20, 'null' => false ], // JV, Deposit, Receipt
            'source_id' => [ 'type' => 'INT', 'unsigned' => true, 'null' => false ],
            'line_no' => [ 'type' => 'INT', 'unsigned' => true, 'null' => true ],
            'voucher_no' => [ 'type' => 'VARCHAR', 'constraint' => 50, 'null' => true ],
            'account_code' => [ 'type' => 'VARCHAR', 'constraint' => 20, 'null' => false ],
            'description' => [ 'type' => 'VARCHAR', 'constraint' => 255, 'null' => true ],
            'debit' => [ 'type' => 'DECIMAL', 'constraint' => '12,2', 'default' => 0 ],
            'credit' => [ 'type' => 'DECIMAL', 'constraint' => '12,2', 'default' => 0 ],
            'created_at' => [ 'type' => 'DATETIME', 'null' => true ],
            'updated_at' => [ 'type' => 'DATETIME', 'null' => true ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey('account_code');
        $this->forge->addKey(['source_type','source_id']);
        $this->forge->createTable('general_ledger', true);
    }

    public function down()
    {
        $this->forge->dropTable('general_ledger', true);
    }
}
