<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateSettingsVat extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'school_name' => [
                'type' => 'VARCHAR',
                'constraint' => 150,
                'null' => true,
            ],
            'vat_number' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => true,
            ],
            // Store VAT rate as percent (e.g., 15 for 15%)
            'vat_rate' => [
                'type' => 'DECIMAL',
                'constraint' => '6,3',
                'default' => 15.000,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('settings_vat', true);
    }

    public function down()
    {
        $this->forge->dropTable('settings_vat', true);
    }
}
