<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddLogoToSettingsVat extends Migration
{
    public function up()
    {
        $this->forge->addColumn('settings_vat', [
            'logo_path' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
                'after' => 'vat_rate',
            ],
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('settings_vat', 'logo_path');
    }
}
