<?php
namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class ChartOfAccountsSeeder extends Seeder
{
    public function run()
    {
        $data = [
            // Top-level groups
            ['code'=>'1000','name_en'=>'Assets','name_ar'=>'الأصول','type'=>'Asset','parent_id'=>null,'level'=>1,'is_postable'=>0,'normal_balance'=>'Debit','is_active'=>1],
            ['code'=>'2000','name_en'=>'Liabilities','name_ar'=>'الخصوم','type'=>'Liability','parent_id'=>null,'level'=>1,'is_postable'=>0,'normal_balance'=>'Credit','is_active'=>1],
            ['code'=>'3000','name_en'=>'Equity','name_ar'=>'حقوق الملكية','type'=>'Equity','parent_id'=>null,'level'=>1,'is_postable'=>0,'normal_balance'=>'Credit','is_active'=>1],
            ['code'=>'4000','name_en'=>'Revenue','name_ar'=>'الإيرادات','type'=>'Revenue','parent_id'=>null,'level'=>1,'is_postable'=>0,'normal_balance'=>'Credit','is_active'=>1],
            ['code'=>'5000','name_en'=>'Expenses','name_ar'=>'المصروفات','type'=>'Expense','parent_id'=>null,'level'=>1,'is_postable'=>0,'normal_balance'=>'Debit','is_active'=>1],
        ];

        $this->db->table('chart_of_accounts')->insertBatch($data);

        // Fetch IDs for grouping
        $groups = $this->db->table('chart_of_accounts')->select('id, code')->whereIn('code',['1000','2000','3000','4000','5000'])->get()->getResultArray();
        $ids = [];
        foreach ($groups as $g) { $ids[$g['code']] = (int)$g['id']; }

        $children = [
            // Assets
            ['code'=>'1010','name_en'=>'Cash on Hand','name_ar'=>'الصندوق','type'=>'Asset','parent_id'=>$ids['1000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Debit','is_active'=>1],
            ['code'=>'1020','name_en'=>'Bank Accounts','name_ar'=>'حسابات بنكية','type'=>'Asset','parent_id'=>$ids['1000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Debit','is_active'=>1],
            ['code'=>'1100','name_en'=>'Accounts Receivable','name_ar'=>'الذمم المدينة','type'=>'Asset','parent_id'=>$ids['1000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Debit','is_active'=>1],
            ['code'=>'1370','name_en'=>'VAT Input Receivable','name_ar'=>'ضريبة قيمة مضافة مدفوعة','type'=>'Asset','parent_id'=>$ids['1000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Debit','is_active'=>1],
            ['code'=>'1500','name_en'=>'Property and Equipment','name_ar'=>'الممتلكات والمعدات','type'=>'Asset','parent_id'=>$ids['1000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Debit','is_active'=>1],
            ['code'=>'1510','name_en'=>'Accumulated Depreciation','name_ar'=>'مجمع الإهلاك','type'=>'Asset','parent_id'=>$ids['1000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Credit','is_active'=>1],
            // Liabilities
            ['code'=>'2100','name_en'=>'Accounts Payable','name_ar'=>'الدائنون','type'=>'Liability','parent_id'=>$ids['2000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Credit','is_active'=>1],
            ['code'=>'2200','name_en'=>'Accrued Expenses','name_ar'=>'مصروفات مستحقة','type'=>'Liability','parent_id'=>$ids['2000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Credit','is_active'=>1],
            ['code'=>'2310','name_en'=>'VAT Output Payable','name_ar'=>'ضريبة قيمة مضافة مستحقة','type'=>'Liability','parent_id'=>$ids['2000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Credit','is_active'=>1],
            ['code'=>'2400','name_en'=>'Unearned Revenue','name_ar'=>'إيرادات مؤجلة','type'=>'Liability','parent_id'=>$ids['2000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Credit','is_active'=>1],
            // Equity
            ['code'=>'3100','name_en'=>'Share Capital','name_ar'=>'رأس المال','type'=>'Equity','parent_id'=>$ids['3000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Credit','is_active'=>1],
            ['code'=>'3200','name_en'=>'Retained Earnings','name_ar'=>'الأرباح المحتجزة','type'=>'Equity','parent_id'=>$ids['3000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Credit','is_active'=>1],
            // Revenue
            ['code'=>'4100','name_en'=>'Tuition Fee Revenue','name_ar'=>'إيرادات الرسوم الدراسية','type'=>'Revenue','parent_id'=>$ids['4000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Credit','is_active'=>1],
            ['code'=>'4200','name_en'=>'Other Income','name_ar'=>'إيرادات أخرى','type'=>'Revenue','parent_id'=>$ids['4000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Credit','is_active'=>1],
            // Expenses
            ['code'=>'5100','name_en'=>'Salaries Expense','name_ar'=>'مصروف الرواتب','type'=>'Expense','parent_id'=>$ids['5000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Debit','is_active'=>1],
            ['code'=>'5200','name_en'=>'Rent Expense','name_ar'=>'مصروف الإيجار','type'=>'Expense','parent_id'=>$ids['5000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Debit','is_active'=>1],
            ['code'=>'5300','name_en'=>'Utilities Expense','name_ar'=>'مصروف الخدمات','type'=>'Expense','parent_id'=>$ids['5000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Debit','is_active'=>1],
            ['code'=>'5400','name_en'=>'Depreciation Expense','name_ar'=>'مصروف الإهلاك','type'=>'Expense','parent_id'=>$ids['5000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Debit','is_active'=>1],
            ['code'=>'5500','name_en'=>'Supplies Expense','name_ar'=>'مصروف اللوازم','type'=>'Expense','parent_id'=>$ids['5000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Debit','is_active'=>1],
            ['code'=>'5600','name_en'=>'Bad Debt Expense','name_ar'=>'مصروف الديون المعدومة','type'=>'Expense','parent_id'=>$ids['5000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Debit','is_active'=>1],
            ['code'=>'5700','name_en'=>'Bank Charges','name_ar'=>'مصروفات بنكية','type'=>'Expense','parent_id'=>$ids['5000'],'level'=>2,'is_postable'=>1,'normal_balance'=>'Debit','is_active'=>1],
        ];

        $this->db->table('chart_of_accounts')->insertBatch($children);
    }
}
