<?php
namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use CodeIgniter\I18n\Time;

class NationalitiesSeeder extends Seeder
{
    public function run()
    {
        $now = Time::now('UTC');
        $data = [
            ['name_en' => 'Afghanistan', 'name_ar' => 'أفغانستان'],
            ['name_en' => 'Albania', 'name_ar' => 'ألبانيا'],
            ['name_en' => 'Algeria', 'name_ar' => 'الجزائر'],
            ['name_en' => 'Andorra', 'name_ar' => 'أندورا'],
            ['name_en' => 'Angola', 'name_ar' => 'أنغولا'],
            ['name_en' => 'Antigua and Barbuda', 'name_ar' => 'أنتيغوا وبربودا'],
            ['name_en' => 'Argentina', 'name_ar' => 'الأرجنتين'],
            ['name_en' => 'Armenia', 'name_ar' => 'أرمينيا'],
            ['name_en' => 'Australia', 'name_ar' => 'أستراليا'],
            ['name_en' => 'Austria', 'name_ar' => 'النمسا'],
            ['name_en' => 'Azerbaijan', 'name_ar' => 'أذربيجان'],
            ['name_en' => 'Bahamas', 'name_ar' => 'جزر البهاما'],
            ['name_en' => 'Bahrain', 'name_ar' => 'البحرين'],
            ['name_en' => 'Bangladesh', 'name_ar' => 'بنغلاديش'],
            ['name_en' => 'Barbados', 'name_ar' => 'بربادوس'],
            ['name_en' => 'Belarus', 'name_ar' => 'بيلاروس'],
            ['name_en' => 'Belgium', 'name_ar' => 'بلجيكا'],
            ['name_en' => 'Belize', 'name_ar' => 'بليز'],
            ['name_en' => 'Benin', 'name_ar' => 'بنين'],
            ['name_en' => 'Bhutan', 'name_ar' => 'بوتان'],
            ['name_en' => 'Bolivia', 'name_ar' => 'بوليفيا'],
            ['name_en' => 'Bosnia and Herzegovina', 'name_ar' => 'البوسنة والهرسك'],
            ['name_en' => 'Botswana', 'name_ar' => 'بوتسوانا'],
            ['name_en' => 'Brazil', 'name_ar' => 'البرازيل'],
            ['name_en' => 'Brunei', 'name_ar' => 'بروناي'],
            ['name_en' => 'Bulgaria', 'name_ar' => 'بلغاريا'],
            ['name_en' => 'Burkina Faso', 'name_ar' => 'بوركينا فاسو'],
            ['name_en' => 'Burundi', 'name_ar' => 'بوروندي'],
            ['name_en' => 'Cabo Verde', 'name_ar' => 'الرأس الأخضر'],
            ['name_en' => 'Cambodia', 'name_ar' => 'كمبوديا'],
            ['name_en' => 'Cameroon', 'name_ar' => 'الكاميرون'],
            ['name_en' => 'Canada', 'name_ar' => 'كندا'],
            ['name_en' => 'Central African Republic', 'name_ar' => 'جمهورية أفريقيا الوسطى'],
            ['name_en' => 'Chad', 'name_ar' => 'تشاد'],
            ['name_en' => 'Chile', 'name_ar' => 'تشيلي'],
            ['name_en' => 'China', 'name_ar' => 'الصين'],
            ['name_en' => 'Colombia', 'name_ar' => 'كولومبيا'],
            ['name_en' => 'Comoros', 'name_ar' => 'جزر القمر'],
            ['name_en' => 'Congo (Republic)', 'name_ar' => 'جمهورية الكونغو'],
            ['name_en' => 'Congo (Democratic Republic)', 'name_ar' => 'جمهورية الكونغو الديمقراطية'],
            ['name_en' => 'Costa Rica', 'name_ar' => 'كوستاريكا'],
            ['name_en' => "Côte d'Ivoire", 'name_ar' => 'ساحل العاج'],
            ['name_en' => 'Croatia', 'name_ar' => 'كرواتيا'],
            ['name_en' => 'Cuba', 'name_ar' => 'كوبا'],
            ['name_en' => 'Cyprus', 'name_ar' => 'قبرص'],
            ['name_en' => 'Czechia', 'name_ar' => 'التشيك'],
            ['name_en' => 'Denmark', 'name_ar' => 'الدنمارك'],
            ['name_en' => 'Djibouti', 'name_ar' => 'جيبوتي'],
            ['name_en' => 'Dominica', 'name_ar' => 'دومينيكا'],
            ['name_en' => 'Dominican Republic', 'name_ar' => 'جمهورية الدومينيكان'],
            ['name_en' => 'Ecuador', 'name_ar' => 'الإكوادور'],
            ['name_en' => 'Egypt', 'name_ar' => 'مصر'],
            ['name_en' => 'El Salvador', 'name_ar' => 'السلفادور'],
            ['name_en' => 'Equatorial Guinea', 'name_ar' => 'غينيا الاستوائية'],
            ['name_en' => 'Eritrea', 'name_ar' => 'إريتريا'],
            ['name_en' => 'Estonia', 'name_ar' => 'إستونيا'],
            ['name_en' => 'Eswatini', 'name_ar' => 'إسواتيني'],
            ['name_en' => 'Ethiopia', 'name_ar' => 'إثيوبيا'],
            ['name_en' => 'Fiji', 'name_ar' => 'فيجي'],
            ['name_en' => 'Finland', 'name_ar' => 'فنلندا'],
            ['name_en' => 'France', 'name_ar' => 'فرنسا'],
            ['name_en' => 'Gabon', 'name_ar' => 'الغابون'],
            ['name_en' => 'Gambia', 'name_ar' => 'غامبيا'],
            ['name_en' => 'Georgia', 'name_ar' => 'جورجيا'],
            ['name_en' => 'Germany', 'name_ar' => 'ألمانيا'],
            ['name_en' => 'Ghana', 'name_ar' => 'غانا'],
            ['name_en' => 'Greece', 'name_ar' => 'اليونان'],
            ['name_en' => 'Grenada', 'name_ar' => 'غرينادا'],
            ['name_en' => 'Guatemala', 'name_ar' => 'غواتيمالا'],
            ['name_en' => 'Guinea', 'name_ar' => 'غينيا'],
            ['name_en' => 'Guinea-Bissau', 'name_ar' => 'غينيا بيساو'],
            ['name_en' => 'Guyana', 'name_ar' => 'غيانا'],
            ['name_en' => 'Haiti', 'name_ar' => 'هايتي'],
            ['name_en' => 'Holy See', 'name_ar' => 'الفاتيكان'],
            ['name_en' => 'Honduras', 'name_ar' => 'هندوراس'],
            ['name_en' => 'Hungary', 'name_ar' => 'المجر'],
            ['name_en' => 'Iceland', 'name_ar' => 'آيسلندا'],
            ['name_en' => 'India', 'name_ar' => 'الهند'],
            ['name_en' => 'Indonesia', 'name_ar' => 'إندونيسيا'],
            ['name_en' => 'Iran', 'name_ar' => 'إيران'],
            ['name_en' => 'Iraq', 'name_ar' => 'العراق'],
            ['name_en' => 'Ireland', 'name_ar' => 'أيرلندا'],
            ['name_en' => 'Israel', 'name_ar' => 'إسرائيل'],
            ['name_en' => 'Italy', 'name_ar' => 'إيطاليا'],
            ['name_en' => 'Jamaica', 'name_ar' => 'جامايكا'],
            ['name_en' => 'Japan', 'name_ar' => 'اليابان'],
            ['name_en' => 'Jordan', 'name_ar' => 'الأردن'],
            ['name_en' => 'Kazakhstan', 'name_ar' => 'كازاخستان'],
            ['name_en' => 'Kenya', 'name_ar' => 'كينيا'],
            ['name_en' => 'Kiribati', 'name_ar' => 'كيريباتي'],
            ['name_en' => 'Korea (North)', 'name_ar' => 'كوريا الشمالية'],
            ['name_en' => 'Korea (South)', 'name_ar' => 'كوريا الجنوبية'],
            ['name_en' => 'Kuwait', 'name_ar' => 'الكويت'],
            ['name_en' => 'Kyrgyzstan', 'name_ar' => 'قيرغيزستان'],
            ['name_en' => 'Laos', 'name_ar' => 'لاوس'],
            ['name_en' => 'Latvia', 'name_ar' => 'لاتفيا'],
            ['name_en' => 'Lebanon', 'name_ar' => 'لبنان'],
            ['name_en' => 'Lesotho', 'name_ar' => 'ليسوتو'],
            ['name_en' => 'Liberia', 'name_ar' => 'ليبيريا'],
            ['name_en' => 'Libya', 'name_ar' => 'ليبيا'],
            ['name_en' => 'Liechtenstein', 'name_ar' => 'ليختنشتاين'],
            ['name_en' => 'Lithuania', 'name_ar' => 'ليتوانيا'],
            ['name_en' => 'Luxembourg', 'name_ar' => 'لوكسمبورغ'],
            ['name_en' => 'Madagascar', 'name_ar' => 'مدغشقر'],
            ['name_en' => 'Malawi', 'name_ar' => 'مالاوي'],
            ['name_en' => 'Malaysia', 'name_ar' => 'ماليزيا'],
            ['name_en' => 'Maldives', 'name_ar' => 'المالديف'],
            ['name_en' => 'Mali', 'name_ar' => 'مالي'],
            ['name_en' => 'Malta', 'name_ar' => 'مالطا'],
            ['name_en' => 'Marshall Islands', 'name_ar' => 'جزر مارشال'],
            ['name_en' => 'Mauritania', 'name_ar' => 'موريتانيا'],
            ['name_en' => 'Mauritius', 'name_ar' => 'موريشيوس'],
            ['name_en' => 'Mexico', 'name_ar' => 'المكسيك'],
            ['name_en' => 'Micronesia', 'name_ar' => 'ميكرونيزيا'],
            ['name_en' => 'Moldova', 'name_ar' => 'مولدوفا'],
            ['name_en' => 'Monaco', 'name_ar' => 'موناكو'],
            ['name_en' => 'Mongolia', 'name_ar' => 'منغوليا'],
            ['name_en' => 'Montenegro', 'name_ar' => 'الجبل الأسود'],
            ['name_en' => 'Morocco', 'name_ar' => 'المغرب'],
            ['name_en' => 'Mozambique', 'name_ar' => 'موزمبيق'],
            ['name_en' => 'Myanmar', 'name_ar' => 'ميانمار'],
            ['name_en' => 'Namibia', 'name_ar' => 'ناميبيا'],
            ['name_en' => 'Nauru', 'name_ar' => 'ناورو'],
            ['name_en' => 'Nepal', 'name_ar' => 'نيبال'],
            ['name_en' => 'Netherlands', 'name_ar' => 'هولندا'],
            ['name_en' => 'New Zealand', 'name_ar' => 'نيوزيلندا'],
            ['name_en' => 'Nicaragua', 'name_ar' => 'نيكاراغوا'],
            ['name_en' => 'Niger', 'name_ar' => 'النيجر'],
            ['name_en' => 'Nigeria', 'name_ar' => 'نيجيريا'],
            ['name_en' => 'North Macedonia', 'name_ar' => 'مقدونيا الشمالية'],
            ['name_en' => 'Norway', 'name_ar' => 'النرويج'],
            ['name_en' => 'Oman', 'name_ar' => 'عمان'],
            ['name_en' => 'Pakistan', 'name_ar' => 'باكستان'],
            ['name_en' => 'Palau', 'name_ar' => 'بالاو'],
            ['name_en' => 'Panama', 'name_ar' => 'بنما'],
            ['name_en' => 'Papua New Guinea', 'name_ar' => 'بابوا غينيا الجديدة'],
            ['name_en' => 'Paraguay', 'name_ar' => 'باراغواي'],
            ['name_en' => 'Peru', 'name_ar' => 'بيرو'],
            ['name_en' => 'Philippines', 'name_ar' => 'الفلبين'],
            ['name_en' => 'Poland', 'name_ar' => 'بولندا'],
            ['name_en' => 'Portugal', 'name_ar' => 'البرتغال'],
            ['name_en' => 'Qatar', 'name_ar' => 'قطر'],
            ['name_en' => 'Romania', 'name_ar' => 'رومانيا'],
            ['name_en' => 'Russia', 'name_ar' => 'روسيا'],
            ['name_en' => 'Rwanda', 'name_ar' => 'رواندا'],
            ['name_en' => 'Saint Kitts and Nevis', 'name_ar' => 'سانت كيتس ونيفيس'],
            ['name_en' => 'Saint Lucia', 'name_ar' => 'سانت لوسيا'],
            ['name_en' => 'Saint Vincent and the Grenadines', 'name_ar' => 'سانت فينسنت والغرينادين'],
            ['name_en' => 'Samoa', 'name_ar' => 'ساموا'],
            ['name_en' => 'San Marino', 'name_ar' => 'سان مارينو'],
            ['name_en' => 'Sao Tome and Principe', 'name_ar' => 'ساو تومي وبرينسيبي'],
            ['name_en' => 'Saudi Arabia', 'name_ar' => 'السعودية'],
            ['name_en' => 'Senegal', 'name_ar' => 'السنغال'],
            ['name_en' => 'Serbia', 'name_ar' => 'صربيا'],
            ['name_en' => 'Seychelles', 'name_ar' => 'سيشل'],
            ['name_en' => 'Sierra Leone', 'name_ar' => 'سيراليون'],
            ['name_en' => 'Singapore', 'name_ar' => 'سنغافورة'],
            ['name_en' => 'Slovakia', 'name_ar' => 'سلوفاكيا'],
            ['name_en' => 'Slovenia', 'name_ar' => 'سلوفينيا'],
            ['name_en' => 'Solomon Islands', 'name_ar' => 'جزر سليمان'],
            ['name_en' => 'Somalia', 'name_ar' => 'الصومال'],
            ['name_en' => 'South Africa', 'name_ar' => 'جنوب أفريقيا'],
            ['name_en' => 'South Sudan', 'name_ar' => 'جنوب السودان'],
            ['name_en' => 'Spain', 'name_ar' => 'إسبانيا'],
            ['name_en' => 'Sri Lanka', 'name_ar' => 'سريلانكا'],
            ['name_en' => 'Sudan', 'name_ar' => 'السودان'],
            ['name_en' => 'Suriname', 'name_ar' => 'سورينام'],
            ['name_en' => 'Sweden', 'name_ar' => 'السويد'],
            ['name_en' => 'Switzerland', 'name_ar' => 'سويسرا'],
            ['name_en' => 'Syria', 'name_ar' => 'سوريا'],
            ['name_en' => 'Taiwan', 'name_ar' => 'تايوان'],
            ['name_en' => 'Tajikistan', 'name_ar' => 'طاجيكستان'],
            ['name_en' => 'Tanzania', 'name_ar' => 'تنزانيا'],
            ['name_en' => 'Thailand', 'name_ar' => 'تايلاند'],
            ['name_en' => 'Timor-Leste', 'name_ar' => 'تيمور الشرقية'],
            ['name_en' => 'Togo', 'name_ar' => 'توغو'],
            ['name_en' => 'Tonga', 'name_ar' => 'تونغا'],
            ['name_en' => 'Trinidad and Tobago', 'name_ar' => 'ترينيداد وتوباغو'],
            ['name_en' => 'Tunisia', 'name_ar' => 'تونس'],
            ['name_en' => 'Turkey', 'name_ar' => 'تركيا'],
            ['name_en' => 'Turkmenistan', 'name_ar' => 'تركمانستان'],
            ['name_en' => 'Tuvalu', 'name_ar' => 'توفالو'],
            ['name_en' => 'Uganda', 'name_ar' => 'أوغندا'],
            ['name_en' => 'Ukraine', 'name_ar' => 'أوكرانيا'],
            ['name_en' => 'United Arab Emirates', 'name_ar' => 'الإمارات العربية المتحدة'],
            ['name_en' => 'United Kingdom', 'name_ar' => 'المملكة المتحدة'],
            ['name_en' => 'United States', 'name_ar' => 'الولايات المتحدة'],
            ['name_en' => 'Uruguay', 'name_ar' => 'أوروغواي'],
            ['name_en' => 'Uzbekistan', 'name_ar' => 'أوزبكستان'],
            ['name_en' => 'Vanuatu', 'name_ar' => 'فانواتو'],
            ['name_en' => 'Venezuela', 'name_ar' => 'فنزويلا'],
            ['name_en' => 'Vietnam', 'name_ar' => 'فيتنام'],
            ['name_en' => 'Yemen', 'name_ar' => 'اليمن'],
            ['name_en' => 'Zambia', 'name_ar' => 'زامبيا'],
            ['name_en' => 'Zimbabwe', 'name_ar' => 'زيمبابوي'],
        ];

        $builder = $this->db->table('nationalities');
        foreach ($data as $row) {
            $exists = $builder->where('name_en', $row['name_en'])->get()->getFirstRow();
            if ($exists) {
                continue;
            }
            $row['created_at'] = $now;
            $row['updated_at'] = $now;
            $builder->insert($row);
        }
    }
}
