<?php
namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use CodeIgniter\I18n\Time;

class ReligionsSeeder extends Seeder
{
    public function run()
    {
        $now = Time::now('UTC');
        $data = [
            ['name_en' => 'Muslim', 'name_ar' => 'مسلم'],
            ['name_en' => 'Christian', 'name_ar' => 'مسيحي'],
            ['name_en' => 'Jewish', 'name_ar' => 'يهودي'],
            ['name_en' => 'Hindu', 'name_ar' => 'هندوسي'],
            ['name_en' => 'Buddhist', 'name_ar' => 'بوذي'],
            ['name_en' => 'Other', 'name_ar' => 'أخرى'],
        ];

        $builder = $this->db->table('religions');
        foreach ($data as $row) {
            $exists = $builder->where('name_en', $row['name_en'])->get()->getFirstRow();
            if ($exists) {
                continue;
            }
            $row['created_at'] = $now;
            $row['updated_at'] = $now;
            $builder->insert($row);
        }
    }
}