<?= $this->include('layout/header') ?>
<h5 class="mb-3"><?= esc($title) ?></h5>

<?php if (!empty($errors)): ?>
  <div class="alert alert-danger">
    <ul class="mb-0">
      <?php foreach ($errors as $err): ?>
        <li><?= esc($err) ?></li>
      <?php endforeach; ?>
    </ul>
  </div>
<?php endif; ?>

<?php $isEdit = !empty($account); ?>
<form method="post" action="<?= $isEdit ? '/accounting/accounts/update/' . (int)$account['id'] : '/accounting/accounts/store' ?>">
  <?= csrf_field() ?>
  <div class="row g-3">
    <div class="col-md-3">
      <label class="form-label"><?= lang('App.account_code') ?></label>
      <input type="text" name="code" value="<?= esc($account['code'] ?? '') ?>" class="form-control" required />
    </div>
    <div class="col-md-4">
      <label class="form-label"><?= lang('App.name_en') ?></label>
      <input type="text" name="name_en" value="<?= esc($account['name_en'] ?? '') ?>" class="form-control" required />
    </div>
    <div class="col-md-4">
      <label class="form-label"><?= lang('App.name_ar') ?></label>
      <input type="text" name="name_ar" value="<?= esc($account['name_ar'] ?? '') ?>" class="form-control" />
    </div>
    <div class="col-md-3">
      <label class="form-label"><?= lang('App.account_type') ?></label>
      <select class="form-select" name="type" required>
        <option value="">--</option>
        <?php 
          $typeLabels = [
            'Asset' => lang('App.account_type_asset'),
            'Liability' => lang('App.account_type_liability'),
            'Equity' => lang('App.account_type_equity'),
            'Revenue' => lang('App.account_type_revenue'),
            'Expense' => lang('App.account_type_expense'),
          ];
        ?>
        <?php foreach ($types as $t): ?>
          <option value="<?= esc($t) ?>" <?= isset($account['type']) && $account['type']===$t ? 'selected' : '' ?>><?= esc($typeLabels[$t] ?? $t) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-4">
      <label class="form-label"><?= lang('App.parent_account') ?></label>
      <?php $locale = service('language')->getLocale(); ?>
      <select class="form-select" name="parent_id">
        <option value="">--</option>
        <?php foreach ($parents as $p): ?>
          <?php $name = $locale==='ar' ? ($p['name_ar'] ?? $p['name_en']) : ($p['name_en'] ?? $p['name_ar']); ?>
          <?php $label = $p['code'] . ' - ' . ($name ?? ''); ?>
          <option value="<?= (int)$p['id'] ?>" <?= isset($account['parent_id']) && (int)$account['parent_id']===(int)$p['id'] ? 'selected' : '' ?>><?= esc($label) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label"><?= lang('App.normal_balance') ?></label>
      <select class="form-select" name="normal_balance" required>
        <option value="">--</option>
        <?php foreach ($normalBalances as $nb): ?>
          <?php $nbLabel = $nb==='Debit' ? lang('App.debit') : ($nb==='Credit' ? lang('App.credit') : $nb); ?>
          <option value="<?= esc($nb) ?>" <?= isset($account['normal_balance']) && $account['normal_balance']===$nb ? 'selected' : '' ?>><?= esc($nbLabel) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label d-block">&nbsp;</label>
      <div class="form-check form-check-inline">
        <input class="form-check-input" type="checkbox" name="is_postable" value="1" <?= !empty($account) ? ($account['is_postable'] ? 'checked' : '') : 'checked' ?> />
        <label class="form-check-label"><?= lang('App.is_postable') ?></label>
      </div>
      <div class="form-check form-check-inline ms-3">
        <input class="form-check-input" type="checkbox" name="is_active" value="1" <?= !empty($account) ? ($account['is_active'] ? 'checked' : '') : 'checked' ?> />
        <label class="form-check-label"><?= lang('App.active') ?></label>
      </div>
    </div>
  </div>
  <div class="mt-3">
    <button type="submit" class="btn btn-primary"><?= lang('App.save') ?></button>
    <a href="/accounting/accounts" class="btn btn-outline-secondary"><?= lang('App.cancel') ?></a>
  </div>
</form>
<?= $this->include('layout/footer') ?>