<?= $this->include('layout/header') ?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h5 class="mb-0"><?= lang('App.chart_of_accounts') ?></h5>
  <a href="/accounting/accounts/create" class="btn btn-primary btn-sm">
    <i class="bi bi-plus"></i> <?= lang('App.add_account') ?>
  </a>
</div>

<form class="row g-2 mb-3" method="get" action="/accounting/accounts">
  <div class="col-auto">
    <input type="text" name="q" value="<?= esc($query) ?>" class="form-control form-control-sm" placeholder="<?= lang('App.search') ?>" />
  </div>
  <div class="col-auto">
    <button class="btn btn-outline-secondary btn-sm" type="submit"><?= lang('App.search') ?></button>
    <a class="btn btn-outline-secondary btn-sm" href="/accounting/accounts"><?= lang('App.reset') ?></a>
  </div>
</form>

<div class="table-responsive">
  <table class="table table-sm table-striped align-middle">
    <thead>
      <tr>
        <th style="width: 110px;">"><?= lang('App.account_code') ?></th>
        <th>"><?= lang('App.name_en') ?> / <?= lang('App.name_ar') ?></th>
        <th style="width: 120px;">"><?= lang('App.account_type') ?></th>
        <th style="width: 140px;">"><?= lang('App.normal_balance') ?></th>
        <th style="width: 90px;">"><?= lang('App.is_postable') ?></th>
        <th style="width: 90px;">"><?= lang('App.active') ?></th>
        <th style="width: 100px;"></th>
      </tr>
    </thead>
    <tbody>
      <?php $locale = service('language')->getLocale(); ?>
      <?php 
        $typeLabels = [
          'Asset' => lang('App.account_type_asset'),
          'Liability' => lang('App.account_type_liability'),
          'Equity' => lang('App.account_type_equity'),
          'Revenue' => lang('App.account_type_revenue'),
          'Expense' => lang('App.account_type_expense'),
        ];
        $nbLabels = [
          'Debit' => lang('App.debit'),
          'Credit' => lang('App.credit'),
        ];
      ?>
      <?php foreach ($accounts as $acc): ?>
        <?php $display = $locale === 'ar' ? ($acc['name_ar'] ?? $acc['name_en']) : ($acc['name_en'] ?? $acc['name_ar']); ?>
        <tr>
          <td><?= esc($acc['code']) ?></td>
          <td>
            <div class="fw-semibold"><?= esc($display) ?></div>
            <div class="text-muted small">EN: <?= esc($acc['name_en']) ?> | AR: <?= esc($acc['name_ar'] ?? '-') ?></div>
          </td>
          <td><?= esc($typeLabels[$acc['type']] ?? $acc['type']) ?></td>
          <td><?= esc($nbLabels[$acc['normal_balance']] ?? $acc['normal_balance']) ?></td>
          <td><?= $acc['is_postable'] ? lang('App.yes') : lang('App.no') ?></td>
          <td><?= $acc['is_active'] ? lang('App.active') : lang('App.inactive') ?></td>
          <td>
            <a class="btn btn-outline-primary btn-sm" href="/accounting/accounts/edit/<?= (int) $acc['id'] ?>">
              <?= lang('App.edit') ?>
            </a>
          </td>
        </tr>
      <?php endforeach; ?>
      <?php if (empty($accounts)): ?>
        <tr>
          <td colspan="7" class="text-center text-muted py-4"><?= lang('App.no_entries_yet') ?></td>
        </tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>
<?= $this->include('layout/footer') ?>