<?= $this->include('layout/header') ?>
<?php $isArabic = (service('language')->getLocale() === 'ar'); ?>
<div class="container my-4" dir="<?= $isArabic ? 'rtl' : 'ltr' ?>">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0"><?= $isArabic ? 'إضافة إيداع بنكي' : 'Add Bank Deposit' ?></h4>
    <a href="/accounting/deposits" class="btn btn-outline-secondary">
      <i class="bi bi-arrow-left"></i> <?= lang('App.back') ?>
    </a>
  </div>

  <div class="card shadow-sm">
    <div class="card-body">
      <form method="post" action="/accounting/deposits/store">
        <div class="row g-3">
          <div class="col-md-3">
            <label class="form-label"><?= lang('App.date') ?></label>
            <input type="date" class="form-control" name="date" value="<?= esc(date('Y-m-d')) ?>" required />
          </div>
          <div class="col-md-5">
            <label class="form-label"><?= $isArabic ? 'الحساب البنكي' : 'Bank Account' ?></label>
            <select class="form-select" name="bank_account" required>
              <option value=""><?= lang('App.choose') ?></option>
              <?php foreach (($accounts ?? []) as $a): ?>
                <option value="<?= esc($a['code']) ?>"><?= esc($a['display']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-4">
            <label class="form-label"><?= lang('App.amount') ?></label>
            <input type="number" class="form-control" name="amount" step="0.01" min="0" placeholder="0.00" required />
          </div>
          <div class="col-12">
            <label class="form-label"><?= lang('App.description') ?></label>
            <textarea class="form-control" name="description" rows="3" placeholder="<?= $isArabic ? 'أدخل وصفًا (اختياري)' : 'Enter description (optional)' ?>"></textarea>
          </div>
        </div>
        <div class="d-flex justify-content-end mt-3">
          <button type="submit" class="btn btn-primary">
            <i class="bi bi-check2-circle"></i> <?= $isArabic ? 'حفظ' : 'Save' ?>
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
