<?= $this->include('layout/header') ?>
<?php /** @var array $accounts */ /** @var array $selected */ /** @var array $entries */ /** @var string $title */ ?>
<?php $isArabic = (service('language')->getLocale() === 'ar'); ?>
<div class="container py-3" dir="<?= $isArabic ? 'rtl' : 'ltr' ?>">
  <div class="card shadow-sm">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="mb-0"><?= esc($title) ?></h5>
      <a href="/accounting/journal-vouchers/create" class="btn btn-outline-primary"><?= lang('App.journal_vouchers') ?></a>
    </div>
    <div class="card-body">
      <?php if (session('success')): ?>
        <div class="alert alert-success mb-3"><?= esc(session('success')) ?></div>
      <?php endif; ?>
      <?php if (session('error')): ?>
        <div class="alert alert-danger mb-3"><?= esc(session('error')) ?></div>
      <?php endif; ?>

      <form method="get" class="row g-3 mb-3">
        <div class="col-md-4">
          <label class="form-label"><?= $isArabic ? 'الحساب' : 'Account' ?></label>
          <select name="account" class="form-select">
            <option value="">-- <?= lang('App.select') ?> --</option>
            <?php foreach ($accounts as $a): ?>
              <option value="<?= esc($a['code']) ?>" <?= ($selected['account'] ?? '') === ($a['code'] ?? '') ? 'selected' : '' ?>>
                <?= esc(($a['code'] ?? '') . ' - ' . ($a['name'] ?? '')) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label"><?= lang('App.date') ?> (<?= $isArabic ? 'من' : 'From' ?>)</label>
          <input type="date" name="from" class="form-control" value="<?= esc($selected['from'] ?? '') ?>" />
        </div>
        <div class="col-md-3">
          <label class="form-label"><?= lang('App.date') ?> (<?= $isArabic ? 'إلى' : 'To' ?>)</label>
          <input type="date" name="to" class="form-control" value="<?= esc($selected['to'] ?? '') ?>" />
        </div>
        <div class="col-md-2 d-flex align-items-end">
          <button type="submit" class="btn btn-primary w-100">
            <?= lang('App.filter') ?>
          </button>
        </div>
      </form>

      <div class="table-responsive">
        <table class="table table-striped table-bordered">
          <thead class="table-light">
            <tr>
              <th><?= lang('App.date') ?></th>
              <th><?= $isArabic ? 'القسيمة' : 'Voucher' ?></th>
              <th><?= $isArabic ? 'المصدر' : 'Source' ?></th>
              <th><?= $isArabic ? 'الحساب' : 'Account' ?></th>
              <th><?= lang('App.description') ?></th>
              <th><?= lang('App.debit') ?></th>
              <th><?= lang('App.credit') ?></th>
              <?php if (($selected['account'] ?? '') !== ''): ?>
                <th><?= lang('App.balance') ?></th>
              <?php endif; ?>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($entries)): foreach ($entries as $e): ?>
              <tr>
                <td><?= esc($e['date'] ?? '') ?></td>
                <td><?= esc($e['voucher_no'] ?? '') ?></td>
                <td><?= esc($e['source'] ?? '') ?></td>
                <td><?= esc($e['account_code'] ?? '') ?></td>
                <td><?= esc($e['description'] ?? '') ?></td>
                <td class="text-end"><?= esc(number_format((float)($e['debit'] ?? 0), 2)) ?></td>
                <td class="text-end"><?= esc(number_format((float)($e['credit'] ?? 0), 2)) ?></td>
                <?php if (($selected['account'] ?? '') !== ''): ?>
                  <td class="text-end"><?= esc(number_format((float)($e['balance'] ?? 0), 2)) ?></td>
                <?php endif; ?>
              </tr>
            <?php endforeach; else: ?>
              <tr>
                <td colspan="<?= ($selected['account'] ?? '') !== '' ? '8' : '7' ?>" class="text-center text-muted">
                  <?= lang('App.no_entries_yet') ?>
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
