<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-person-plus-fill me-2"></i> <?= esc($title ?? 'Employees') ?> - Add
    <a href="/hr/employees" class="btn btn-outline-secondary btn-sm ms-auto">
      <i class="bi bi-arrow-left me-1"></i> Back
    </a>
  </div>
  <div class="card-body">
    <?php if (session()->getFlashdata('error')): ?>
      <div class="alert alert-danger"><?= esc(session()->getFlashdata('error')) ?></div>
    <?php endif; ?>

    <form action="/hr/employees/store" method="post">
      <?= csrf_field() ?>
      <div class="row g-3">
        <div class="col-md-3">
          <label class="form-label">Employee No</label>
          <input type="text" name="employee_no" class="form-control" required>
        </div>
        <div class="col-md-3">
          <label class="form-label">First Name</label>
          <input type="text" name="first_name" class="form-control" required>
        </div>
        <div class="col-md-3">
          <label class="form-label">Last Name</label>
          <input type="text" name="last_name" class="form-control" required>
        </div>
        <div class="col-md-3">
          <label class="form-label">Gender</label>
          <select name="gender" class="form-select">
            <option value="">-- choose --</option>
            <option>Male</option>
            <option>Female</option>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label">Date of Birth</label>
          <input type="date" name="dob" class="form-control">
        </div>
        <div class="col-md-3">
          <label class="form-label">Email</label>
          <input type="email" name="email" class="form-control">
        </div>
        <div class="col-md-3">
          <label class="form-label">Phone</label>
          <input type="text" name="phone" class="form-control">
        </div>
        <div class="col-md-3">
          <label class="form-label">Hire Date</label>
          <input type="date" name="hire_date" class="form-control">
        </div>
        <div class="col-md-6">
          <label class="form-label">Address</label>
          <input type="text" name="address" class="form-control">
        </div>
        <div class="col-md-3">
          <label class="form-label">Department</label>
          <input type="text" name="department" class="form-control">
        </div>
        <div class="col-md-3">
          <label class="form-label">Position</label>
          <input type="text" name="position" class="form-control">
        </div>
        <div class="col-md-3">
          <label class="form-label">Salary Grade</label>
          <select name="salary_grade_id" class="form-select">
            <option value="">-- choose --</option>
            <?php foreach (($grades ?? []) as $g): ?>
              <option value="<?= (int)$g->id ?>"><?= esc($g->name) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label">Status</label>
          <select name="status" class="form-select">
            <option>Active</option>
            <option>Inactive</option>
          </select>
        </div>
      </div>
      <div class="mt-3">
        <button type="submit" class="btn btn-primary"><i class="bi bi-save me-1"></i> <?= lang('App.save') ?></button>
        <a href="/hr/employees" class="btn btn-secondary ms-2"><i class="bi bi-x-circle me-1"></i> <?= lang('App.cancel') ?></a>
      </div>
    </form>
  </div>
</div>
<?= $this->include('layout/footer') ?>
