<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-people-fill me-2"></i> <?= esc($title ?? 'Employees') ?>
    <a href="/hr/employees/create" class="btn btn-primary btn-sm ms-auto">
      <i class="bi bi-plus-lg me-1"></i> <?= lang('App.add') ?>
    </a>
  </div>
  <div class="card-body">
    <?php if (session()->getFlashdata('message')): ?>
      <div class="alert alert-success"><?= esc(session()->getFlashdata('message')) ?></div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('error')): ?>
      <div class="alert alert-danger"><?= esc(session()->getFlashdata('error')) ?></div>
    <?php endif; ?>

    <div class="table-responsive">
      <table class="table table-striped table-bordered">
        <thead>
          <tr>
            <th>Employee No</th>
            <th>Name</th>
            <th>Department</th>
            <th>Position</th>
            <th>Salary Grade</th>
            <th>Status</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach (($employees ?? []) as $emp): ?>
            <tr>
              <td><?= esc($emp->employee_no) ?></td>
              <td><?= esc($emp->first_name . ' ' . $emp->last_name) ?></td>
              <td><?= esc($emp->department) ?></td>
              <td><?= esc($emp->position) ?></td>
              <td><?= esc($emp->grade_name) ?></td>
              <td><?= esc($emp->status) ?></td>
            </tr>
          <?php endforeach; ?>
          <?php if (empty($employees)): ?>
            <tr>
              <td colspan="6" class="text-center text-muted">No employees yet.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
