<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-badge-vr me-2"></i> <?= esc($title ?? 'Salary Grades') ?>
    <a href="/hr/salary-grades/create" class="btn btn-primary btn-sm ms-auto">
      <i class="bi bi-plus-lg me-1"></i> <?= lang('App.add') ?>
    </a>
  </div>
  <div class="card-body">
    <?php if (session()->getFlashdata('message')): ?>
      <div class="alert alert-success"><?= esc(session()->getFlashdata('message')) ?></div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('error')): ?>
      <div class="alert alert-danger"><?= esc(session()->getFlashdata('error')) ?></div>
    <?php endif; ?>

    <div class="table-responsive">
      <table class="table table-striped table-bordered">
        <thead>
          <tr>
            <th>Code</th>
            <th>Name</th>
            <th>Base Salary</th>
            <th>Currency</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach (($grades ?? []) as $g): ?>
            <tr>
              <td><?= esc($g->code) ?></td>
              <td><?= esc($g->name) ?></td>
              <td><?= esc(number_format((float)$g->base_salary, 2)) ?></td>
              <td><?= esc($g->currency) ?></td>
            </tr>
          <?php endforeach; ?>
          <?php if (empty($grades)): ?>
            <tr>
              <td colspan="4" class="text-center text-muted">No salary grades yet.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
