<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-clock-history me-2"></i> Receipt History
  </div>
  <div class="card-body">
    <div class="mb-3">
      <form method="get" action="/payments/history" class="input-group">
        <input type="text" name="q" value="<?= esc($query ?? '') ?>" class="form-control" placeholder="Search by ID, iqama, mobile or name" />
        <button class="btn btn-outline-secondary" type="submit"><i class="bi bi-search"></i></button>
      </form>
    </div>

    <div class="table-responsive">
      <table class="table table-striped table-hover">
        <thead>
          <tr>
            <th>#</th>
            <th>Receipt No</th>
            <th>Student</th>
            <th class="text-end">Total</th>
            <th class="text-end">VAT</th>
            <th class="text-end">Grand Total</th>
            <th>Created</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($rows)): ?>
            <?php $i=1; foreach ($rows as $r): ?>
              <tr>
                <td><?= $i++ ?></td>
                <td><?= esc($r['receipt_no'] ?? '') ?></td>
                <td><strong><?= esc($r['student_id'] ?? '') ?></strong><br/><?= esc(($r['first_name'] ?? '') . ' ' . ($r['last_name'] ?? '')) ?></td>
                <td class="text-end"><?= esc(number_format((float)($r['total'] ?? 0), 2)) ?></td>
                <td class="text-end"><?= esc(number_format((float)($r['vat'] ?? 0), 2)) ?></td>
                <td class="text-end"><?= esc(number_format((float)($r['grand_total'] ?? 0), 2)) ?></td>
                <td><?= esc(date('Y-m-d H:i', strtotime($r['created_at'] ?? 'now'))) ?></td>
                <td>
                  <a class="btn btn-sm btn-outline-primary" href="/payments/print/<?= $r['id'] ?>" target="_blank"><i class="bi bi-printer"></i> Print</a>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="8" class="text-center text-muted">No receipts found.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>