<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Apply for Admission</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="icon" type="image/png" href="<?= base_url(is_file(FCPATH . 'assets/logo.png') ? 'assets/logo.png' : 'favicon.ico') ?>" />
</head>
<body class="bg-indigo-50 min-h-screen">
  <!-- Public header (no dashboard/sidebar) -->
  <header class="bg-white shadow">
    <div class="max-w-6xl mx-auto px-4 py-4 flex items-center justify-between">
      <a href="/" class="flex items-center gap-3">
        <img src="<?= base_url(is_file(FCPATH . 'assets/logo.png') ? 'assets/logo.png' : 'favicon.ico') ?>" alt="Logo" class="h-8 w-8 object-contain" />
        <span class="font-semibold text-indigo-700">Jil Alsalam Schools</span>
      </a>
      <nav class="flex items-center gap-4">
        <a href="/" class="text-slate-700 hover:text-indigo-700">Home</a>
      </nav>
    </div>
  </header>

  <!-- Page content -->
  <main class="max-w-6xl mx-auto px-4 py-8">
    <div class="bg-white rounded-xl shadow">
      <div class="px-6 py-4 border-b">
        <h1 class="text-xl font-semibold text-indigo-700">Apply to admission</h1>
        <p class="text-sm text-slate-600">Basic info and parent info only. School completes remaining details.</p>
      </div>
      <div class="p-6">
        <?php if (session()->getFlashdata('success')): ?>
          <div class="mb-4 rounded-lg bg-green-50 text-green-800 px-4 py-3 border border-green-200"><?= esc(session()->getFlashdata('success')) ?></div>
        <?php endif; ?>
        <?php if (session()->getFlashdata('error')): ?>
          <div class="mb-4 rounded-lg bg-red-50 text-red-800 px-4 py-3 border border-red-200"><?= esc(session()->getFlashdata('error')) ?></div>
        <?php endif; ?>

        <form method="post" action="/apply" class="space-y-8">
          <?= csrf_field() ?>

          <!-- Basic Info -->
          <section>
            <h2 class="text-lg font-semibold text-slate-800 mb-4">Basic Info</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
              <div>
                <label class="block text-sm font-medium text-slate-700">Student Name (English) *</label>
                <input type="text" class="mt-1 block w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" name="name_en" value="<?= esc(old('name_en')) ?>" required />
              </div>
              <div>
                <label class="block text-sm font-medium text-slate-700">Student Name (Arabic)</label>
                <input type="text" class="mt-1 block w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" name="name_ar" value="<?= esc(old('name_ar')) ?>" />
              </div>
              <div>
                <label class="block text-sm font-medium text-slate-700">Gender *</label>
                <select class="mt-1 block w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" name="gender" required>
                  <option value="Male" <?= old('gender') === 'Male' ? 'selected' : '' ?>>Male</option>
                  <option value="Female" <?= old('gender') === 'Female' ? 'selected' : '' ?>>Female</option>
                </select>
              </div>
              <div>
                <label class="block text-sm font-medium text-slate-700">Desired Program / Class</label>
                <select class="mt-1 block w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" name="class_id">
                  <option value="">-- choose --</option>
                  <?php foreach ($classes as $c): ?>
                    <option value="<?= $c['id'] ?>" <?= old('class_id') == $c['id'] ? 'selected' : '' ?>><?= esc($c['name_en'] ?? $c['name_ar'] ?? '') ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div>
                <label class="block text-sm font-medium text-slate-700">Mobile</label>
                <input type="text" class="mt-1 block w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" name="mobile" value="<?= esc(old('mobile')) ?>" />
              </div>
              <div>
                <label class="block text-sm font-medium text-slate-700">Student iqama No.</label>
                <input type="text" class="mt-1 block w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" name="student_iqama" value="<?= esc(old('student_iqama')) ?>" />
              </div>
              <div class="md:col-span-2">
                <label class="block text-sm font-medium text-slate-700">Home Address</label>
                <textarea class="mt-1 block w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" name="address" rows="2"><?= esc(old('address')) ?></textarea>
              </div>
            </div>
          </section>

          <!-- Parent / Guardian Info -->
          <section>
            <h2 class="text-lg font-semibold text-slate-800 mb-4">Parent / Guardian Info</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
              <div>
                <label class="block text-sm font-medium text-slate-700">Father Name *</label>
                <input type="text" class="mt-1 block w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" name="father_name" value="<?= esc(old('father_name')) ?>" required />
              </div>
              <div>
                <label class="block text-sm font-medium text-slate-700">Occupation</label>
                <input type="text" class="mt-1 block w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" name="occupation" value="<?= esc(old('occupation')) ?>" />
              </div>
              <div>
                <label class="block text-sm font-medium text-slate-700">Iqama Number</label>
                <input type="text" class="mt-1 block w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" name="parent_iqama" value="<?= esc(old('parent_iqama')) ?>" />
              </div>
              <div>
                <label class="block text-sm font-medium text-slate-700">Telephone Number</label>
                <input type="text" class="mt-1 block w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" name="telephone" value="<?= esc(old('telephone')) ?>" />
              </div>
            </div>
          </section>

          <div class="flex items-center justify-end gap-3">
            <button type="reset" class="inline-flex items-center px-4 py-2 rounded-md border border-slate-300 text-slate-700 hover:bg-slate-50">Clear</button>
            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-700 text-white shadow">Submit Application</button>
          </div>
        </form>
      </div>
    </div>
  </main>

  <footer class="mt-10 py-6 text-center text-slate-600">
    &copy; <?= date('Y') ?> Jil Alsalam Schools
  </footer>
</body>
</html>