<?php
/**
 * Public Homepage for Jil Alsalam Schools
 * Modern, elegant hero slider with Tailwind.
 * Single-language rendering with one toggle to switch.
 */
$locale = $locale ?? (service('language')->getLocale());
$isArabic = ($locale === 'ar');
$dir = $isArabic ? 'rtl' : 'ltr';
$align = $isArabic ? 'text-right' : 'text-left';

// Localized strings
$t = [
  'brand'        => $isArabic ? 'مدارس جيل السلام' : 'Jil Alsalam Schools',
  'brand_sub'    => $isArabic ? 'رياض الأطفال • الدمام' : 'Preschool • Dammam',
  'nav_home'     => $isArabic ? 'الرئيسية' : 'Home',
  'nav_about'    => $isArabic ? 'من نحن' : 'About',
  'nav_programs' => $isArabic ? 'البرامج' : 'Programs',
  'nav_adm'      => $isArabic ? 'القبول' : 'Admissions',
  'nav_contact'  => $isArabic ? 'تواصل معنا' : 'Contact',
  'login'        => $isArabic ? 'تسجيل الدخول' : 'Login',
  'toggle'       => $isArabic ? 'English' : 'العربية',
  'hero_title'   => $isArabic ? 'مرحبًا بكم في مدارس جيل السلام' : 'Welcome to Jil Alsalam Schools',
  'hero_sub'     => $isArabic ? 'نلهم العقول الصغيرة نحو مستقبلٍ مشرق' : 'Inspiring Young Minds Toward a Bright Future',
  'hero_enroll'  => $isArabic ? 'سجّل الآن' : 'Enroll Now',
  'hero_program' => $isArabic ? 'استكشف البرامج' : 'Explore Programs',
  'about_title'  => $isArabic ? 'نبذة عن مدرستنا' : 'About Our School',
  'about_desc'   => $isArabic ? 'نحن رياض أطفال دولية ناشئة في الدمام، نُنمّي الفضول واللطف وأسس التعلم.' : 'We are a startup international preschool in Dammam, fostering curiosity, kindness, and foundational learning.',
  'programs_title'=> $isArabic ? 'البرامج' : 'Programs',
  'programs_desc' => $isArabic ? 'تعرّف على برامج الطفولة المبكرة لدينا.' : 'Explore our early childhood programs.',
  'p1_title'     => $isArabic ? 'التعلّم المبكر' : 'Early Learning',
  'p1_desc'      => $isArabic ? 'تعلّم بالاكتشاف واللعب، الحروف والأرقام.' : 'Play-based discovery, letters and numbers.',
  'p2_title'     => $isArabic ? 'اللعب الإبداعي' : 'Creative Play',
  'p2_desc'      => $isArabic ? 'فن وموسيقى وحركة للتعبير عن الذات.' : 'Art, music, movement for self-expression.',
  'p3_title'     => $isArabic ? 'الأساس الأكاديمي' : 'Academic Foundation',
  'p3_desc'      => $isArabic ? 'اللغة والرياضيات والمهارات الاجتماعية.' : 'Language, math, and social skills.',
  'adm_title'    => $isArabic ? 'القبول' : 'Admissions',
  'adm_desc'     => $isArabic ? 'مقاعد متاحة للفصل القادم.' : 'Open seats for the upcoming term.',
  'adm_cta'      => $isArabic ? 'قدّم / سجّل' : 'Apply / Enroll',
  'addr'         => $isArabic ? 'الدمام، المملكة العربية السعودية' : 'Dammam, Saudi Arabia',
  'email'        => $isArabic ? 'البريد الإلكتروني' : 'Email',
  'phone'        => $isArabic ? 'الهاتف' : 'Phone',
  'copyright'    => $isArabic ? 'جميع الحقوق محفوظة' : 'All rights reserved',
];
$toggleTarget = $isArabic ? 'en' : 'ar';
?>
<!DOCTYPE html>
<html lang="<?= esc($locale) ?>" dir="<?= $dir ?>">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($t['brand']) ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
  <link rel="icon" type="image/png" href="<?= base_url(is_file(FCPATH . 'assets/logo.png') ? 'assets/logo.png' : 'favicon.ico') ?>" />
  <style>
    body { font-family: <?= $isArabic ? "'Cairo', 'Tajawal', system-ui, -apple-system, Segoe UI, Roboto, 'Helvetica Neue', Arial, sans-serif" : "'Poppins', system-ui, -apple-system, Segoe UI, Roboto, 'Helvetica Neue', Arial, sans-serif" ?>; }
    .fade-in { opacity: 0; transform: translateY(10px); }
    .fade-in.show { opacity: 1; transform: translateY(0); transition: opacity 700ms ease, transform 700ms ease; }
  </style>
</head>
<body class="bg-white text-slate-800">
  <!-- Header with inline language toggle -->
  <header class="w-full bg-gradient-to-r from-sky-500 to-indigo-500">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
      <div class="flex items-center justify-between py-4">
        <!-- Brand -->
        <div class="flex items-center gap-3">
          <img src="<?= base_url(is_file(FCPATH . 'assets/logo.png') ? 'assets/logo.png' : 'favicon.ico') ?>" alt="<?= esc($t['brand']) ?>" class="h-10 w-10 object-contain" />
          <div class="text-white font-semibold <?= $align ?>">
            <div><?= esc($t['brand']) ?></div>
            <div class="text-xs opacity-90"><?= esc($t['brand_sub']) ?></div>
          </div>
        </div>
        <!-- Nav, Toggle, and Login -->
        <div class="flex items-center gap-3 md:gap-6">
          <nav class="hidden md:flex items-center gap-4 text-white font-medium <?= $align ?>">
            <a href="#home" class="hover:underline"><?= esc($t['nav_home']) ?></a>
            <a href="#about" class="hover:underline"><?= esc($t['nav_about']) ?></a>
            <a href="#programs" class="hover:underline"><?= esc($t['nav_programs']) ?></a>
            <a href="#admissions" class="hover:underline"><?= esc($t['nav_adm']) ?></a>
            <a href="#contact" class="hover:underline"><?= esc($t['nav_contact']) ?></a>
          </nav>
          <!-- Language toggle: globe icon + label, aligned inline -->
          <a href="?lang=<?= $toggleTarget ?>" aria-label="Toggle language" class="inline-flex items-center gap-2 px-3 py-2 rounded-md border border-white/60 text-white/90 hover:bg-white hover:text-sky-700 transition">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5">
              <circle cx="12" cy="12" r="9" />
              <path d="M3.6 9h16.8M3.6 15h16.8" />
              <path d="M12 3a13 13 0 0 1 0 18M12 3a13 13 0 0 0 0 18" />
            </svg>
            <span class="text-sm font-medium"><?= esc($t['toggle']) ?></span>
          </a>
          <a href="/login" class="inline-flex items-center bg-white text-sky-700 px-4 py-2 rounded-md shadow hover:shadow-lg transition">
            <?= esc($t['login']) ?>
          </a>
        </div>
      </div>
    </div>
  </header>

  <!-- Modern full-width Hero Slider (fade) -->
  <section id="home" class="relative w-full h-[65vh] md:h-[80vh]">
    <!-- Slider container -->
    <div class="absolute inset-0">
      <!-- Slides stacked, faded -->
      <div class="slide absolute inset-0 bg-[url('/assets/slider/slide1.jpg')] bg-cover bg-center bg-fixed opacity-100 transition-opacity duration-700"></div>
      <div class="slide absolute inset-0 bg-[url('/assets/slider/slide2.jpg')] bg-cover bg-center bg-fixed opacity-0 transition-opacity duration-700"></div>
      <div class="slide absolute inset-0 bg-[url('/assets/slider/slide3.jpg')] bg-cover bg-center bg-fixed opacity-0 transition-opacity duration-700"></div>
      <!-- Dark overlay for contrast -->
      <div class="absolute inset-0 bg-black/50"></div>
    </div>

    <!-- Caption content -->
    <div class="absolute inset-0 flex items-center">
      <div class="max-w-7xl mx-auto w-full px-6">
        <div class="<?= $isArabic ? 'ml-auto' : '' ?> max-w-2xl fade-in show <?= $align ?>">
          <h1 class="text-white font-bold tracking-tight text-4xl md:text-5xl">
            <?= esc($t['hero_title']) ?>
          </h1>
          <p class="mt-3 text-white/90 text-lg">
            <?= esc($t['hero_sub']) ?>
          </p>
          <div class="mt-6 flex items-center gap-3 <?= $align ?>">
            <a href="/apply" class="inline-flex items-center bg-white text-sky-700 px-5 py-2.5 rounded-md shadow hover:shadow-lg transition">
              <?= esc($t['hero_enroll']) ?>
            </a>
            <a href="#programs" class="inline-flex items-center bg-white/20 text-white px-5 py-2.5 rounded-md border border-white/40 hover:bg-white hover:text-sky-700 transition">
              <?= esc($t['hero_program']) ?>
            </a>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- About Section -->
  <section id="about" class="bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-14">
      <div class="fade-in show <?= $align ?>">
        <h2 class="text-3xl font-bold text-indigo-700">
          <?= esc($t['about_title']) ?>
        </h2>
        <p class="mt-3 text-slate-700">
          <?= esc($t['about_desc']) ?>
        </p>
      </div>
    </div>
  </section>

  <!-- Programs Cards -->
  <section id="programs" class="bg-indigo-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-14">
      <div class="fade-in show <?= $align ?> mb-6">
        <h3 class="text-2xl font-semibold text-indigo-700"><?= esc($t['programs_title']) ?></h3>
        <p class="text-slate-600"><?= esc($t['programs_desc']) ?></p>
      </div>
      <div class="grid sm:grid-cols-2 md:grid-cols-3 gap-6">
        <div class="bg-white rounded-xl shadow hover:shadow-xl transition p-6">
          <h4 class="text-lg font-bold text-sky-700"><?= esc($t['p1_title']) ?></h4>
          <p class="mt-2 text-slate-700"><?= esc($t['p1_desc']) ?></p>
        </div>
        <div class="bg-white rounded-xl shadow hover:shadow-xl transition p-6">
          <h4 class="text-lg font-bold text-sky-700"><?= esc($t['p2_title']) ?></h4>
          <p class="mt-2 text-slate-700"><?= esc($t['p2_desc']) ?></p>
        </div>
        <div class="bg-white rounded-xl shadow hover:shadow-xl transition p-6">
          <h4 class="text-lg font-bold text-sky-700"><?= esc($t['p3_title']) ?></h4>
          <p class="mt-2 text-slate-700"><?= esc($t['p3_desc']) ?></p>
        </div>
      </div>
    </div>
  </section>

  <!-- Admissions CTA -->
  <section id="admissions" class="bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-14">
      <div class="fade-in show <?= $align ?>">
        <h3 class="text-2xl font-semibold text-indigo-700"><?= esc($t['adm_title']) ?></h3>
        <p class="text-slate-600"><?= esc($t['adm_desc']) ?></p>
        <div class="mt-6">
          <a href="/apply" class="inline-flex items-center bg-indigo-600 hover:bg-indigo-700 text-white font-semibold px-6 py-3 rounded-lg shadow">
            <?= esc($t['adm_cta']) ?>
          </a>
        </div>
      </div>
    </div>
  </section>

  <!-- Contact Section -->
  <section id="contact" class="bg-indigo-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-14">
      <div class="grid md:grid-cols-2 gap-10">
        <div class="fade-in show <?= $align ?>">
          <h3 class="text-2xl font-semibold text-indigo-700"><?= esc($t['nav_contact']) ?></h3>
          <p class="mt-2 text-slate-700"><?= esc($t['addr']) ?></p>
        </div>
        <div class="fade-in show">
          <div class="flex items-center gap-3">
            <span class="text-indigo-700 font-medium"><?= esc($t['email']) ?>:</span>
            <a href="mailto:info@jilalsalam.sch.sa" class="text-sky-700 hover:underline">info@jilalsalam.sch.sa</a>
          </div>
          <div class="flex items-center gap-3 mt-2">
            <span class="text-indigo-700 font-medium"><?= esc($t['phone']) ?>:</span>
            <a href="tel:+966500000000" class="text-sky-700 hover:underline">+966 50 000 0000</a>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Footer -->
  <footer class="bg-white border-t">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6 flex items-center justify-between">
      <div class="flex items-center gap-3">
        <img src="<?= base_url(is_file(FCPATH . 'assets/logo.png') ? 'assets/logo.png' : 'favicon.ico') ?>" alt="<?= esc($t['brand']) ?>" class="h-8 w-8 object-contain" />
        <div class="text-slate-600 text-sm">&copy; <?= date('Y') ?> <?= esc($t['brand']) ?> — <?= esc($t['copyright']) ?></div>
      </div>
      <a href="/login" class="inline-flex items-center bg-indigo-600 hover:bg-indigo-700 text-white px-3 py-2 rounded-md shadow">
        <?= esc($t['login']) ?>
      </a>
    </div>
  </footer>
</body>
</html>

