<?= $this->include('layout/header') ?>
<?php
  $isArabic = (service('language')->getLocale() === 'ar');
  $filters = $filters ?? ['from' => date('Y-m-01'), 'to' => date('Y-m-d'), 'class_id' => 0, 'section_id' => 0, 'payment_type_id' => 0];
  $labels = [
    'filters' => $isArabic ? 'تصفية' : 'Filters',
    'from' => $isArabic ? 'من' : 'From',
    'to' => $isArabic ? 'إلى' : 'To',
    'class' => $isArabic ? 'الصف' : 'Class',
    'section' => $isArabic ? 'الشعبة' : 'Section',
    'payment_type' => $isArabic ? 'نوع الدفع' : 'Payment Type',
    'apply' => $isArabic ? 'تطبيق' : 'Apply',
    'reset' => $isArabic ? 'إعادة ضبط' : 'Reset',
    'date' => $isArabic ? 'التاريخ' : 'Date',
    'receipt_no' => $isArabic ? 'رقم الإيصال' : 'Receipt No.',
    'student' => $isArabic ? 'اسم الطالب' : 'Student Name',
    'class_col' => $isArabic ? 'الصف' : 'Class',
    'section_col' => $isArabic ? 'الشعبة' : 'Section',
    'payment_desc' => $isArabic ? 'الوصف' : 'Payment',
    'amount' => $isArabic ? 'المبلغ' : 'Amount',
    'total' => $isArabic ? 'الإجمالي' : 'Total',
    'no_rows' => $isArabic ? 'لا توجد نتائج في الفترة المحددة' : 'No rows for selected period',
  ];
?>

<div class="card">
  <div class="card-header d-flex align-items-center justify-content-between">
    <div><i class="bi bi-cash-stack me-2"></i> <?= esc($title ?? ($isArabic ? 'تقارير المدفوعات' : 'Payments Reports')) ?></div>
    <div class="small text-muted">
      <?= sprintf($isArabic ? 'من: %s إلى: %s' : 'From: %s To: %s', esc($filters['from']), esc($filters['to'])) ?>
      <?php if (!empty($selectedPaymentTypeLabel)) : ?>
        &nbsp;•&nbsp;<?= $isArabic ? 'الوصف:' : 'Payment Description:' ?> <strong><?= esc($selectedPaymentTypeLabel) ?></strong>
      <?php else : ?>
        &nbsp;•&nbsp;<strong><?= $isArabic ? 'جميع الأنواع' : 'All Types' ?></strong>
      <?php endif; ?>
    </div>
  </div>
  <div class="card-body">
    <!-- Filters -->
    <form class="row g-2 mb-3" method="get" action="<?= current_url() ?>">
      <div class="col-md-2">
        <label class="form-label"><?= esc($labels['from']) ?></label>
        <input type="date" class="form-control" name="from" value="<?= esc($filters['from']) ?>" />
      </div>
      <div class="col-md-2">
        <label class="form-label"><?= esc($labels['to']) ?></label>
        <input type="date" class="form-control" name="to" value="<?= esc($filters['to']) ?>" />
      </div>
      <div class="col-md-3">
        <label class="form-label"><?= esc($labels['class']) ?></label>
        <select class="form-select" name="class_id">
          <option value="0"><?= $isArabic ? 'الكل' : 'All' ?></option>
          <?php foreach (($classes ?? []) as $cl): $clLabel = $isArabic ? ($cl['name_ar'] ?? $cl['name_en'] ?? '') : ($cl['name_en'] ?? $cl['name_ar'] ?? ''); ?>
            <option value="<?= (int)($cl['id'] ?? 0) ?>" <?= ((int)($filters['class_id'] ?? 0) === (int)($cl['id'] ?? 0)) ? 'selected' : '' ?>><?= esc($clLabel) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label"><?= esc($labels['section']) ?></label>
        <select class="form-select" name="section_id">
          <option value="0"><?= $isArabic ? 'الكل' : 'All' ?></option>
          <?php foreach (($sections ?? []) as $sec): $secLabel = $isArabic ? ($sec['name_ar'] ?? $sec['name_en'] ?? '') : ($sec['name_en'] ?? $sec['name_ar'] ?? ''); ?>
            <option value="<?= (int)($sec['id'] ?? 0) ?>" <?= ((int)($filters['section_id'] ?? 0) === (int)($sec['id'] ?? 0)) ? 'selected' : '' ?>><?= esc($secLabel) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label"><?= esc($labels['payment_type']) ?></label>
        <select class="form-select" name="payment_type_id">
          <option value="0"><?= $isArabic ? 'الكل' : 'All' ?></option>
          <?php foreach (($paymentTypes ?? []) as $pt): $ptLabel = $isArabic ? ($pt['description_ar'] ?? $pt['description_en'] ?? '') : ($pt['description_en'] ?? $pt['description_ar'] ?? ''); ?>
            <option value="<?= (int)($pt['id'] ?? 0) ?>" <?= ((int)($filters['payment_type_id'] ?? 0) === (int)($pt['id'] ?? 0)) ? 'selected' : '' ?>><?= esc($ptLabel) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-12 d-flex gap-2">
        <button type="submit" class="btn btn-primary"><i class="bi bi-funnel me-1"></i> <?= esc($labels['apply']) ?></button>
        <a href="<?= site_url('reports/payments') ?>" class="btn btn-outline-secondary"><i class="bi bi-x-circle me-1"></i> <?= esc($labels['reset']) ?></a>
      </div>
    </form>

    <!-- Results table -->
    <div class="table-responsive">
      <table class="table table-striped table-bordered align-middle">
        <thead class="table-light">
          <tr>
            <th style="width: 10%"><?= esc($labels['date']) ?></th>
            <th style="width: 12%"><?= esc($labels['receipt_no']) ?></th>
            <th><?= esc($labels['student']) ?></th>
            <th style="width: 12%"><?= esc($labels['class_col']) ?></th>
            <th style="width: 12%"><?= esc($labels['section_col']) ?></th>
            <th><?= esc($labels['payment_desc']) ?></th>
            <th style="width: 12%" class="text-end"><?= esc($labels['amount']) ?></th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($rows)) : ?>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><?= esc(date('Y-m-d', strtotime($r['date'] ?? ''))) ?></td>
                <td><?= esc($r['receipt_no'] ?? '') ?></td>
                <td><?= esc($r['student'] ?? '') ?></td>
                <td><?= esc($r['class'] ?? '') ?></td>
                <td><?= esc($r['section'] ?? '') ?></td>
                <td><?= esc($r['payment_type'] ?? '') ?></td>
                <td class="text-end"><?= number_format((float)($r['amount'] ?? 0), 2) ?></td>
              </tr>
            <?php endforeach; ?>
          <?php else : ?>
            <tr>
              <td colspan="7" class="text-center text-muted py-4"><?= esc($labels['no_rows']) ?></td>
            </tr>
          <?php endif; ?>
        </tbody>
        <tfoot>
          <tr>
            <th colspan="6" class="text-end"><?= esc($labels['total']) ?></th>
            <th class="text-end"><?= number_format((float)($totalAmount ?? 0), 2) ?></th>
          </tr>
        </tfoot>
      </table>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
