<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-translate me-2"></i> <?= esc($title ?? 'Language Settings') ?>
  </div>
  <div class="card-body">
    <?php if (session('success')): ?>
      <div class="alert alert-success"><?= esc(session('success')) ?></div>
    <?php elseif (session('error')): ?>
      <div class="alert alert-danger"><?= esc(session('error')) ?></div>
    <?php endif; ?>

    <form method="post" action="/settings/language" class="row g-3">
      <?= csrf_field() ?>
      <div class="col-md-6">
        <label class="form-label">Select Language</label>
        <select name="locale" class="form-select">
          <option value="en" <?= ($currentLocale === 'en') ? 'selected' : '' ?>>English</option>
          <option value="ar" <?= ($currentLocale === 'ar') ? 'selected' : '' ?>>العربية</option>
        </select>
      </div>
      <div class="col-md-6 d-flex align-items-end">
        <button class="btn btn-primary" type="submit"><i class="bi bi-save me-1"></i> Save</button>
      </div>
    </form>
    <p class="text-muted mt-3 mb-0">Language is stored per session for now.</p>
  </div>
</div>
<?= $this->include('layout/footer') ?>