<?= $this->include('layout/header') ?>
<div class="row">
  <div class="col-lg-8">
    <div class="card">
      <div class="card-header">
        <?php if ($user): ?>Edit User<?php else: ?>Add User<?php endif; ?>
      </div>
      <div class="card-body">
        <?php if (session()->getFlashdata('error')): ?>
          <div class="alert alert-danger py-2"><?= esc(session()->getFlashdata('error')) ?></div>
        <?php endif; ?>
        <form method="post" action="<?= $user ? '/settings/users/update/'.(int)$user['id'] : '/settings/users/store' ?>">
          <div class="mb-3">
            <label class="form-label">Username</label>
            <input type="text" name="username" value="<?= esc($user['username'] ?? '') ?>" class="form-control" required />
          </div>
          <div class="mb-3">
            <label class="form-label">Email</label>
            <input type="email" name="email" value="<?= esc($email ?? '') ?>" class="form-control" required />
          </div>
          <div class="mb-3">
            <label class="form-label">Group</label>
            <select name="group" class="form-select" required>
              <option value="">-- choose --</option>
              <?php foreach (($groups ?? []) as $g): ?>
                <option value="<?= esc($g) ?>" <?= isset($currentGroup) && $currentGroup === $g ? 'selected' : '' ?>><?= esc(ucfirst($g)) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Password <?= $user ? '(leave blank to keep unchanged)' : '' ?></label>
            <input type="password" name="password" class="form-control" <?= $user ? '' : 'required' ?> />
          </div>
          <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary"><?= $user ? 'Update' : 'Create' ?></button>
            <a href="/settings/users" class="btn btn-outline-secondary">Cancel</a>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
