<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-gear me-2"></i> <?= lang('App.vat_settings') ?>
    <a href="/dashboard" class="btn btn-sm btn-outline-secondary ms-auto"><i class="bi bi-arrow-left"></i> <?= lang('App.back') ?></a>
  </div>
  <div class="card-body">
    <?php if (session('success')): ?>
      <div class="alert alert-success d-flex align-items-center"><i class="bi bi-check-circle me-2"></i> <?= esc(session('success')) ?></div>
    <?php endif; ?>
    <?php if (session('error')): ?>
      <div class="alert alert-danger d-flex align-items-center"><i class="bi bi-exclamation-triangle me-2"></i> <?= esc(session('error')) ?></div>
    <?php endif; ?>

    <form method="post" action="/settings/vat" enctype="multipart/form-data">
      <?= csrf_field() ?>
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label"><?= lang('App.school_name') ?></label>
          <input type="text" name="school_name" class="form-control" value="<?= esc($settings['school_name'] ?? '') ?>" placeholder="e.g., JAS International School" />
        </div>
        <div class="col-md-6">
          <label class="form-label"><?= lang('App.vat_number') ?></label>
          <input type="text" name="vat_number" class="form-control" value="<?= esc($settings['vat_number'] ?? '') ?>" placeholder="TRN / VAT Number" />
        </div>
        <div class="col-md-6">
          <label class="form-label"><?= lang('App.vat_rate_percent') ?></label>
          <div class="input-group">
            <input type="number" name="vat_rate" class="form-control" value="<?= esc($settings['vat_rate'] ?? 15) ?>" step="0.01" min="0" max="100" />
            <span class="input-group-text">%</span>
          </div>
          <div class="form-text"><?= lang('App.vat_rate_hint') ?></div>
        </div>
        <div class="col-md-6">
          <label class="form-label">Logo</label>
          <input type="file" name="logo" class="form-control" accept="image/*" />
          <?php if (!empty($settings['logo_path'])): ?>
            <div class="mt-2">
              <img src="<?= base_url('writable/' . $settings['logo_path']) ?>" alt="School Logo" style="height:60px" />
            </div>
          <?php endif; ?>
        </div>
      </div>
      <div class="mt-3">
        <button class="btn btn-primary"><i class="bi bi-save"></i> <?= lang('App.save') ?></button>
      </div>
    </form>
  </div>
</div>
<?= $this->include('layout/footer') ?>