<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
-    <i class="bi bi-building me-2"></i> Classes
+    <i class="bi bi-building me-2"></i> <?= lang('App.classes') ?>
  </div>
  <div class="card-body">
    <?php if (session('success')): ?>
      <div class="alert alert-success"><?= esc(session('success')) ?></div>
    <?php elseif (session('error')): ?>
      <div class="alert alert-danger"><?= esc(session('error')) ?></div>
    <?php endif; ?>

    <form method="post" action="/setup/classes" class="row g-3">
      <?= csrf_field() ?>
      <div class="col-md-5">
-        <label class="form-label">Name (EN)</label>
+        <label class="form-label"><?= lang('App.name_en') ?></label>
        <input type="text" name="name_en" class="form-control" required />
      </div>
      <div class="col-md-5">
-        <label class="form-label">Name (AR)</label>
+        <label class="form-label"><?= lang('App.name_ar') ?></label>
        <input type="text" name="name_ar" class="form-control" />
      </div>
      <div class="col-md-2 d-flex align-items-end">
-        <button class="btn btn-primary w-100" type="submit">Add</button>
+        <button class="btn btn-primary w-100" type="submit"><?= lang('App.add') ?></button>
      </div>
    </form>

    <hr />
    <div class="table-responsive">
      <table class="table table-striped">
        <thead>
          <tr>
-            <th>ID</th>
-            <th>Name (EN)</th>
-            <th>Name (AR)</th>
-            <th>Created</th>
+            <th><?= lang('App.id') ?></th>
+            <th><?= lang('App.name_en') ?></th>
+            <th><?= lang('App.name_ar') ?></th>
+            <th><?= lang('App.created') ?></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($items as $row): ?>
          <tr>
            <td><?= esc($row['id'] ?? '') ?></td>
            <td><?= esc($row['name_en'] ?? '') ?></td>
            <td><?= esc($row['name_ar'] ?? '') ?></td>
            <td><?= esc($row['created_at'] ?? '') ?></td>
          </tr>
          <?php endforeach; ?>
          <?php if (! $items): ?>
-          <tr><td colspan="4" class="text-center text-muted">No entries yet.</td></tr>
+          <tr><td colspan="4" class="text-center text-muted"><?= lang('App.no_entries_yet') ?></td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
