<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-flag me-2"></i> Nationalities
  </div>
  <div class="card-body">
    <?php if (session('success')): ?>
      <div class="alert alert-success"><?= esc(session('success')) ?></div>
    <?php elseif (session('error')): ?>
      <div class="alert alert-danger"><?= esc(session('error')) ?></div>
    <?php endif; ?>

    <form method="post" action="/setup/nationalities" class="row g-3">
      <?= csrf_field() ?>
      <div class="col-md-5">
        <label class="form-label">Name (EN)</label>
        <input type="text" name="name_en" class="form-control" required />
      </div>
      <div class="col-md-5">
        <label class="form-label">Name (AR)</label>
        <input type="text" name="name_ar" class="form-control" />
      </div>
      <div class="col-md-2 d-flex align-items-end">
        <button class="btn btn-primary w-100" type="submit">Add</button>
      </div>
    </form>

    <hr />
    <div class="table-responsive">
      <table class="table table-striped">
        <thead>
          <tr>
            <th>ID</th>
            <th>Name (EN)</th>
            <th>Name (AR)</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($items as $row): ?>
          <tr>
            <td><?= esc($row['id'] ?? '') ?></td>
            <td><?= esc($row['name_en'] ?? '') ?></td>
            <td><?= esc($row['name_ar'] ?? '') ?></td>
          </tr>
          <?php endforeach; ?>
          <?php if (! $items): ?>
          <tr><td colspan="3" class="text-center text-muted">No entries yet.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
