<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-calendar3 me-2"></i> School Year
  </div>
  <div class="card-body">
    <?php if (session('success')): ?>
      <div class="alert alert-success"><?= esc(session('success')) ?></div>
    <?php elseif (session('error')): ?>
      <div class="alert alert-danger"><?= esc(session('error')) ?></div>
    <?php endif; ?>

    <form method="post" action="/setup/school-years" class="row g-3">
      <?= csrf_field() ?>
      <div class="col-md-3">
        <label class="form-label">S/No</label>
        <input type="text" name="sno" class="form-control" required />
      </div>
      <div class="col-md-5">
        <label class="form-label">School Year</label>
        <input type="text" name="school_year" class="form-control" placeholder="2025-2026" required />
      </div>
      <div class="col-md-2">
        <label class="form-label">Status</label>
        <select name="status" class="form-select">
          <option value="active">Active</option>
          <option value="inactive">Inactive</option>
        </select>
      </div>
      <div class="col-md-2 d-flex align-items-end">
        <button class="btn btn-primary w-100" type="submit">Add</button>
      </div>
    </form>

    <hr />
    <div class="table-responsive">
      <table class="table table-striped">
        <thead>
          <tr>
            <th>ID</th>
            <th>S/No</th>
            <th>School Year</th>
            <th>Status</th>
            <th>Created</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($items as $row): ?>
          <tr>
            <td><?= esc($row['id'] ?? '') ?></td>
            <td><?= esc($row['sno'] ?? '') ?></td>
            <td><?= esc($row['school_year'] ?? '') ?></td>
            <td><?= esc($row['status'] ?? '') ?></td>
            <td><?= esc($row['created_at'] ?? '') ?></td>
          </tr>
          <?php endforeach; ?>
          <?php if (! $items): ?>
          <tr><td colspan="5" class="text-center text-muted">No entries yet.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
