<?= $this->include('layout/header') ?>
<div class="container-fluid py-3">
  <h3><?= esc($title) ?></h3>

  <div class="mb-3">
    <div class="d-flex align-items-center gap-3 flex-wrap">
      <form method="get" action="<?= site_url('students') ?>" class="d-flex align-items-center gap-2 flex-wrap">
        <input type="text" name="q" value="<?= esc($filters['q'] ?? '') ?>" class="form-control" placeholder="<?= lang('App.search_all_fields') ?>" style="min-width:260px;" />

        <select name="class_id" class="form-select">
          <option value="0"><?= lang('App.all_classes') ?></option>
          <?php foreach (($classes ?? []) as $c): ?>
            <option value="<?= (int) $c['id'] ?>" <?= (($filters['class_id'] ?? 0) == (int) $c['id']) ? 'selected' : '' ?>><?= esc($c['name_en'] ?? '') ?></option>
          <?php endforeach; ?>
        </select>

        <select name="section_id" class="form-select">
          <option value="0"><?= lang('App.all_sections') ?></option>
          <?php foreach (($sections ?? []) as $s): ?>
            <option value="<?= (int) $s['id'] ?>" <?= (($filters['section_id'] ?? 0) == (int) $s['id']) ? 'selected' : '' ?>><?= esc($s['name_en'] ?? '') ?></option>
          <?php endforeach; ?>
        </select>

        <select name="nationality" class="form-select">
          <option value>
            <?= lang('App.all_nationalities') ?>
          </option>
          <?php foreach (($nationalities ?? []) as $n): ?>
            <?php $val = $n['name_en'] ?? ''; ?>
            <option value="<?= esc($val) ?>" <?= (($filters['nationality'] ?? '') === $val) ? 'selected' : '' ?>><?= esc($val) ?></option>
          <?php endforeach; ?>
        </select>

        <select name="religion" class="form-select">
          <option value=""><?= lang('App.all_religions') ?></option>
           <?php foreach (($religions ?? []) as $r): ?>
             <?php $val = $r['name_en'] ?? ''; ?>
             <option value="<?= esc($val) ?>" <?= (($filters['religion'] ?? '') === $val) ? 'selected' : '' ?>><?= esc($val) ?></option>
           <?php endforeach; ?>
         </select>
 
        <button type="submit" class="btn btn-primary"><?= lang('App.filter') ?></button>
        <a href="<?= site_url('students') ?>" class="btn btn-secondary"><?= lang('App.reset') ?></a>
        <a href="<?= site_url('students/print') . '?' . http_build_query(array_merge(($filters ?? []), ['lang' => service('request')->getLocale()])) ?>" target="_blank" class="btn btn-outline-dark"><?= lang('App.print_preview') ?></a>

      </form>
    </div>
    <div class="mt-2 text-muted">
      <?= lang('App.total_students') ?>: <strong><?= (int) ($totalAll ?? 0) ?></strong> | <?= lang('App.matching') ?>: <strong><?= (int) ($totalFiltered ?? 0) ?></strong>
    </div>
  </div>

  <style>
      /* Match spacing with provided screenshot */
      .students-table th, .students-table td { padding: 0.75rem 1rem; }
      .students-table th { font-weight: 600; color: #6c757d; }
      .students-table img { width: 40px; height: 40px; object-fit: cover; }
      .students-table .action-btn { padding: 0.25rem 0.5rem; }
    </style>
    <div class="table-responsive">
      <table class="students-table table table-striped table-hover align-middle">
        <thead>
          <tr>
            <th><?= lang('App.photo') ?></th>
            <th><?= lang('App.student_id') ?></th>
            <th><?= lang('App.name_en') ?></th>
            <th><?= lang('App.name_ar') ?></th>
            <th><?= lang('App.gender') ?></th>
            <th><?= lang('App.age') ?></th>
            <th><?= lang('App.parent_contact') ?></th>
            <th><?= lang('App.actions') ?></th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($students)): ?>
            <?php foreach ($students as $student): ?>
              <tr>
                <td>
                  <?php if (!empty($student['photo'])): ?>
                    <img src="<?= base_url('photos/' . $student['photo']) ?>" alt="Student Photo" class="rounded-circle">
                  <?php else: ?>
                    <div class="rounded-circle bg-light d-flex align-items-center justify-content-center" style="width:40px;height:40px;font-size:12px;color:#666;"><?= lang('App.no_photo') ?></div>
                  <?php endif; ?>
                </td>
                <td><?= esc($student['student_id']) ?></td>
                <td><?= esc($student['first_name'] . ' ' . $student['last_name']) ?></td>
                <td><?= esc($student['name_ar'] ?? lang('App.no_data')) ?></td>
                <td><?php
                  $g = strtoupper(trim((string)($student['gender'] ?? '')));
                  if ($g === 'M' || $g === 'MALE') { echo lang('App.male'); }
                  elseif ($g === 'F' || $g === 'FEMALE') { echo lang('App.female'); }
                  else { echo ''; }
                ?></td>
                <td>
                  <?php 
                  if (!empty($student['dob'])) {
                    $birthDate = new DateTime($student['dob']);
                    $today = new DateTime();
                    $age = $today->diff($birthDate);
                    echo $age->y . ' ' . lang('App.years');
                  } else {
                    echo lang('App.no_data');
                  }
                  ?>
                </td>
                <td><?= esc($student['parent_phone'] ?? '') ?></td>
                <td class="actions">
                  <a href="<?= base_url('students/profile/' . (int)$student['id']) ?>" class="btn btn-sm btn-outline-primary action-btn" title="Edit">
                    <i class="bi bi-pencil"></i>
                  </a>
                  <a href="#" class="btn btn-sm btn-outline-danger action-btn" title="Delete">
                    <i class="bi bi-trash"></i>
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr>
              <td colspan="8" class="text-center"><?= lang('App.no_data') ?></td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
</div>
<?= $this->include('layout/footer') ?>