<?= $this->include('layout/header'); ?>

<style>
@media print {
  .no-print { display: none !important; }
  .card { border: none !important; box-shadow: none !important; }
  .card-header { background: none !important; border: none !important; }
  body { font-size: 12px; }
  .table { font-size: 11px; }
  .btn { display: none !important; }
  .form-select, .form-label { display: none !important; }
  .mb-3 { margin-bottom: 0.5rem !important; }
}
</style>

<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-journal-text me-2"></i> <?= lang('App.student_statement_ledger') ?>
    <span class="ms-2 text-muted">#<?= esc($student['student_id'] ?? '') ?></span>
    <div class="ms-auto">
      <button onclick="window.print()" class="btn btn-sm btn-primary me-2 no-print">
        <i class="bi bi-printer"></i> <?= lang('App.print') ?>
      </button>
      <a href="<?= base_url('students/profile/' . (int)($student['id'] ?? 0)) ?>" class="btn btn-sm btn-outline-secondary no-print">
        <i class="bi bi-person-lines-fill"></i> <?= lang('App.profile') ?>
      </a>
    </div>
  </div>
  <div class="card-body">
    <form method="get" class="mb-3 d-flex align-items-center gap-2 no-print">
      <label class="form-label mb-0"><?= lang('App.school_year') ?></label>
      <select name="school_year_id" class="form-select w-auto" onchange="this.form.submit()">
        <?php foreach (($years ?? []) as $y): ?>
          <option value="<?= esc($y['id']) ?>" <?= (isset($currentYear['id']) && (int)$currentYear['id'] === (int)$y['id']) ? 'selected' : '' ?>>
            <?= esc($y['school_year'] ?? ('Year #' . $y['id'])) ?> <?= ($y['status'] ?? '') === 'active' ? '(Active)' : '' ?>
          </option>
        <?php endforeach; ?>
      </select>
    </form>

    <div class="row g-3 mb-3">
      <div class="col-md-4">
        <div class="border rounded p-3 h-100">
          <h6 class="mb-2"><?= lang('App.student') ?></h6>
          <div><strong><?= esc(($student['first_name'] ?? '') . ' ' . ($student['last_name'] ?? '')) ?></strong></div>
          <div class="small text-muted"><?= lang('App.id') ?>: <?= esc($student['student_id'] ?? '') ?></div>
          <div class="small text-muted"><?= lang('App.parent') ?>: <?= esc($student['parent_name'] ?? '') ?></div>
          <div class="small text-muted"><?= lang('App.phone') ?>: <?= esc($student['parent_phone'] ?? '') ?></div>
        </div>
      </div>
      <div class="col-md-8">
        <div class="border rounded p-3 h-100">
          <h6 class="mb-2"><?= lang('App.summary') ?> (<?= esc($currentYear['school_year'] ?? lang('App.current_year') ?? 'Current Year') ?>)</h6>
          <div class="row">
            <div class="col-6"><?= lang('App.opening_balance') ?></div>
            <div class="col-6 text-end"><strong><?= esc(number_format((float)($openingBalance ?? 0), 2)) ?></strong></div>
            <div class="col-6"><?= lang('App.total_charges') ?></div>
            <div class="col-6 text-end"><?= esc(number_format((float)($summary['charges'] ?? 0), 2)) ?></div>
            <div class="col-6"><?= lang('App.payments') ?></div>
            <div class="col-6 text-end"><?= esc(number_format((float)($summary['payments'] ?? 0), 2)) ?></div>
            <div class="col-6"><?= lang('App.closing_balance') ?></div>
            <div class="col-6 text-end"><strong><?= esc(number_format((float)($summary['closing'] ?? 0), 2)) ?></strong></div>
          </div>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table class="table table-bordered table-striped">
        <thead>
          <tr>
            <th><?= lang('App.date') ?></th>
            <th><?= lang('App.description') ?></th>
            <th><?= lang('App.debit') ?></th>
            <th><?= lang('App.credit') ?></th>
            <th><?= lang('App.balance') ?></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach (($entries ?? []) as $e): ?>
            <tr>
              <td><?= esc($e['date'] ? date('Y-m-d', strtotime($e['date'])) : '-') ?></td>
              <td><?= esc($e['type'] ?? '') ?></td>
              <td class="text-end"><?= esc(number_format((float)($e['debit'] ?? 0), 2)) ?></td>
              <td class="text-end"><?= esc(number_format((float)($e['credit'] ?? 0), 2)) ?></td>
              <td class="text-end"><?= esc(number_format((float)($e['balance'] ?? 0), 2)) ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?= $this->include('layout/footer'); ?>