<?php
// Student profile edit form
?>
<?= $this->include('layout/header'); ?>
<div class="container py-4">
  <div class="d-flex align-items-center mb-3">
    <h5 class="mb-0"><?= lang('App.profile') ?></h5>
    <span class="text-muted ms-2">#<?= esc($student['student_id']); ?></span>
    <a href="<?= base_url('students'); ?>" class="btn btn-sm btn-outline-secondary ms-auto">
      <i class="bi bi-arrow-left"></i> <?= lang('App.back') ?>
    </a>
    <a href="<?= base_url('students/ledger/' . (int)$student['id']); ?>" class="btn btn-sm btn-outline-primary ms-2">
      <i class="bi bi-journal-text"></i> <?= lang('App.student_statement_ledger') ?>
    </a>
  </div>

  <div class="card shadow-sm">
    <div class="card-body">
      <form action="<?= base_url('students/update/' . (int)$student['id']); ?>" method="post" enctype="multipart/form-data">
        <?= csrf_field(); ?>
        <div class="row g-3">
          <div class="col-md-3 text-center">
            <?php
              $photoUrl = null;
              if (!empty($student['photo'])) {
                $photoUrl = base_url('photos/' . rawurlencode($student['photo']));
              } else {
                // SVG data URI fallback (light grey circle)
                $photoUrl = 'data:image/svg+xml;utf8,' . rawurlencode('<svg xmlns="http://www.w3.org/2000/svg" width="120" height="120"><rect width="100%" height="100%" rx="60" fill="#e9ecef"/><text x="50%" y="52%" text-anchor="middle" fill="#6c757d" font-family="Arial, sans-serif" font-size="14">No Photo</text></svg>');
              }
            ?>
            <img src="<?= esc($photoUrl); ?>" alt="Photo" class="rounded-circle mb-2" style="width:120px;height:120px;object-fit:cover;">
            <div class="small text-muted mb-2"><?= lang('App.current_photo') ?></div>
            <input type="file" name="photo" accept="image/*" class="form-control form-control-sm">
            <div class="form-text">Max 2MB. JPG/PNG/GIF.</div>
          </div>

          <div class="col-md-9">
            <div class="row g-3">
              <div class="col-md-6">
                <label class="form-label"><?= lang('App.student_no') ?></label>
                <input type="text" class="form-control" value="<?= esc($student['student_id']); ?>" readonly>
              </div>
              <div class="col-md-6">
                <label class="form-label"><?= lang('App.name_ar') ?></label>
                <input type="text" name="name_ar" class="form-control" value="<?= esc($student['name_ar'] ?? ''); ?>">
              </div>

              <div class="col-md-6">
                <label class="form-label"><?= lang('App.first_name') ?></label>
                <input type="text" name="first_name" class="form-control" value="<?= esc($student['first_name']); ?>" required>
              </div>
              <div class="col-md-6">
                <label class="form-label"><?= lang('App.last_name') ?></label>
                <input type="text" name="last_name" class="form-control" value="<?= esc($student['last_name']); ?>" required>
              </div>

              <div class="col-md-4">
                <label class="form-label"><?= lang('App.gender') ?></label>
                <?php $genderLabel = ($student['gender'] === 'M' ? 'Male' : ($student['gender'] === 'F' ? 'Female' : '')); ?>
                <select name="gender" class="form-select" required>
                  <option value="">--</option>
                  <option value="Male" <?= $genderLabel==='Male'?'selected':''; ?>><?= lang('App.male') ?></option>
                  <option value="Female" <?= $genderLabel==='Female'?'selected':''; ?>><?= lang('App.female') ?></option>
                </select>
              </div>
              <div class="col-md-4">
                <label class="form-label"><?= lang('App.nationality') ?></label>
                <select name="nationality" class="form-select" required>
                  <?php foreach (($nationalities ?? []) as $n): $val = $n['name_en'] ?? ''; ?>
                    <option value="<?= esc($val) ?>" <?= (($student['nationality'] ?? '') === $val) ? 'selected' : '' ?>><?= esc($val) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-4">
                <label class="form-label"><?= lang('App.religion') ?></label>
                <select name="religion" class="form-select" required>
                  <?php foreach (($religions ?? []) as $r): $val = $r['name_en'] ?? ''; ?>
                    <option value="<?= esc($val) ?>" <?= (($student['religion'] ?? '') === $val) ? 'selected' : '' ?>><?= esc($val) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>

              <div class="col-md-4">
                <label class="form-label"><?= lang('App.date_of_birth') ?></label>
                <input type="date" name="dob" class="form-control" value="<?= esc($student['dob']); ?>">
              </div>
              <div class="col-md-4">
                <label class="form-label"><?= lang('App.parent_name') ?></label>
                <input type="text" name="parent_name" class="form-control" value="<?= esc($student['parent_name']); ?>">
              </div>
              <div class="col-md-4">
                <label class="form-label"><?= lang('App.parent_phone') ?></label>
                <input type="text" name="parent_phone" class="form-control" value="<?= esc($student['parent_phone']); ?>">
              </div>
              <div class="col-12">
                <label class="form-label"><?= lang('App.address') ?></label>
                <input type="text" name="address" class="form-control" value="<?= esc($student['address']); ?>">
              </div>
            </div>
          </div>
        </div>
        <div class="mt-4 d-flex gap-2">
          <button type="submit" class="btn btn-primary">
            <i class="bi bi-save"></i> <?= lang('App.save') ?>
          </button>
          <a href="<?= base_url('students'); ?>" class="btn btn-outline-secondary"><?= lang('App.cancel') ?></a>
        </div>
      </form>
    </div>
  </div>
</div>
<?= $this->include('layout/footer'); ?>